/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.client.armeria;

import com.linecorp.armeria.client.ClientBuilder;
import com.linecorp.armeria.client.ClientFactory;
import com.linecorp.armeria.client.Clients;
import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.client.endpoint.EndpointGroup;
import com.linecorp.armeria.client.endpoint.EndpointSelectionStrategy;
import com.linecorp.armeria.client.endpoint.dns.DnsAddressEndpointGroup;
import com.linecorp.armeria.client.endpoint.dns.DnsAddressEndpointGroupBuilder;
import com.linecorp.armeria.client.endpoint.healthcheck.HealthCheckedEndpointGroup;
import com.linecorp.armeria.client.endpoint.healthcheck.HealthCheckedEndpointGroupBuilder;
import com.linecorp.armeria.common.CommonPools;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.centraldogma.client.AbstractCentralDogmaBuilder;
import com.linecorp.centraldogma.client.armeria.ArmeriaClientConfigurator;
import com.linecorp.centraldogma.client.armeria.CompositeEndpointGroup;
import com.linecorp.centraldogma.client.armeria.DnsAddressEndpointGroupConfigurator;
import com.linecorp.centraldogma.internal.shaded.guava.base.Preconditions;
import com.linecorp.centraldogma.internal.shaded.guava.collect.Iterables;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;

public class AbstractArmeriaCentralDogmaBuilder<B extends AbstractArmeriaCentralDogmaBuilder<B>>
extends AbstractCentralDogmaBuilder<B> {
    private ClientFactory clientFactory = ClientFactory.ofDefault();
    private ArmeriaClientConfigurator clientConfigurator = cb -> {};
    @Nullable
    private Duration healthCheckInterval;
    private DnsAddressEndpointGroupConfigurator dnsAddressEndpointGroupConfigurator = b -> {};
    private ScheduledExecutorService blockingTaskExecutor = CommonPools.blockingTaskExecutor();

    protected final ClientFactory clientFactory() {
        return this.clientFactory;
    }

    public final B clientFactory(ClientFactory clientFactory) {
        this.clientFactory = Objects.requireNonNull(clientFactory, "clientFactory");
        return (B)((Object)((AbstractArmeriaCentralDogmaBuilder)this.self()));
    }

    public final B clientConfigurator(ArmeriaClientConfigurator clientConfigurator) {
        this.clientConfigurator = Objects.requireNonNull(clientConfigurator, "clientConfigurator");
        return (B)((Object)((AbstractArmeriaCentralDogmaBuilder)this.self()));
    }

    public final B dnsAddressEndpointGroupConfigurator(DnsAddressEndpointGroupConfigurator dnsAddressEndpointGroupConfigurator) {
        this.dnsAddressEndpointGroupConfigurator = Objects.requireNonNull(dnsAddressEndpointGroupConfigurator, "dnsAddressEndpointGroupConfigurator");
        return (B)((Object)((AbstractArmeriaCentralDogmaBuilder)this.self()));
    }

    public final B healthCheckInterval(Duration healthCheckInterval) {
        Objects.requireNonNull(healthCheckInterval, "healthCheckInterval");
        Preconditions.checkArgument((!healthCheckInterval.isNegative() ? 1 : 0) != 0, (String)"healthCheckInterval: %s (expected: >= 0)", (Object)healthCheckInterval);
        this.healthCheckInterval = healthCheckInterval;
        return (B)((Object)((AbstractArmeriaCentralDogmaBuilder)this.self()));
    }

    public final B healthCheckIntervalMillis(long healthCheckIntervalMillis) {
        Preconditions.checkArgument((healthCheckIntervalMillis >= 0L ? 1 : 0) != 0, (String)"healthCheckIntervalMillis: %s (expected: >= 0)", (long)healthCheckIntervalMillis);
        this.healthCheckInterval = Duration.ofMillis(healthCheckIntervalMillis);
        return (B)((Object)((AbstractArmeriaCentralDogmaBuilder)this.self()));
    }

    protected final EndpointGroup endpointGroup() throws UnknownHostException {
        EndpointGroup group = this.endpointGroup0();
        if (this.healthCheckInterval != null && this.healthCheckInterval.isZero()) {
            return group;
        }
        HealthCheckedEndpointGroupBuilder healthCheckedEndpointGroupBuilder = HealthCheckedEndpointGroup.builder((EndpointGroup)group, (String)"/monitor/l7check").clientFactory(this.clientFactory).allowEmptyEndpoints(false).protocol(this.isUseTls() ? SessionProtocol.HTTPS : SessionProtocol.HTTP);
        if (this.healthCheckInterval != null) {
            healthCheckedEndpointGroupBuilder.retryInterval(this.healthCheckInterval);
        }
        return healthCheckedEndpointGroupBuilder.build();
    }

    private EndpointGroup endpointGroup0() throws UnknownHostException {
        Set hosts = this.hosts();
        Preconditions.checkState((!hosts.isEmpty() ? 1 : 0) != 0, (Object)"no hosts were added.");
        InetSocketAddress firstHost = (InetSocketAddress)Iterables.getFirst((Iterable)hosts, null);
        if (hosts.size() == 1 && !firstHost.isUnresolved()) {
            return AbstractArmeriaCentralDogmaBuilder.toResolvedHostEndpoint(firstHost);
        }
        ArrayList<Endpoint> staticEndpoints = new ArrayList<Endpoint>();
        ArrayList<EndpointGroup> groups = new ArrayList<EndpointGroup>();
        for (InetSocketAddress addr : hosts) {
            if (addr.isUnresolved()) {
                DnsAddressEndpointGroupBuilder dnsAddressEndpointGroup = DnsAddressEndpointGroup.builder((String)addr.getHostString()).eventLoop(this.clientFactory.eventLoopGroup().next());
                this.dnsAddressEndpointGroupConfigurator.configure(dnsAddressEndpointGroup);
                groups.add((EndpointGroup)dnsAddressEndpointGroup.port(addr.getPort()).build());
                continue;
            }
            staticEndpoints.add(AbstractArmeriaCentralDogmaBuilder.toResolvedHostEndpoint(addr));
        }
        if (!staticEndpoints.isEmpty()) {
            groups.add(EndpointGroup.of(staticEndpoints));
        }
        Object group = groups.size() == 1 ? (EndpointGroup)groups.get(0) : new CompositeEndpointGroup(groups, EndpointSelectionStrategy.roundRobin());
        return group;
    }

    private static Endpoint toResolvedHostEndpoint(InetSocketAddress addr) {
        return Endpoint.of((String)addr.getHostString(), (int)addr.getPort()).withIpAddr(addr.getAddress().getHostAddress());
    }

    protected final ScheduledExecutorService blockingTaskExecutor() {
        return this.blockingTaskExecutor;
    }

    public final B blockingTaskExecutor(ScheduledExecutorService blockingTaskExecutor) {
        Objects.requireNonNull(blockingTaskExecutor, "blockingTaskExecutor");
        this.blockingTaskExecutor = blockingTaskExecutor;
        return (B)((Object)((AbstractArmeriaCentralDogmaBuilder)this.self()));
    }

    protected final ClientBuilder newClientBuilder(String scheme, EndpointGroup endpointGroup, Consumer<ClientBuilder> customizer, String path) {
        ClientBuilder builder = Clients.builder((String)scheme, (EndpointGroup)endpointGroup, (String)path);
        customizer.accept(builder);
        this.clientConfigurator.configure(builder);
        builder.factory(this.clientFactory());
        return builder;
    }
}

