/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.client.armeria;

import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.client.endpoint.DynamicEndpointGroup;
import com.linecorp.armeria.client.endpoint.EndpointSelectionStrategy;
import com.linecorp.centraldogma.client.CentralDogma;
import com.linecorp.centraldogma.client.Watcher;
import com.linecorp.centraldogma.client.armeria.CentralDogmaEndpointGroupBuilder;
import com.linecorp.centraldogma.client.armeria.EndpointListDecoder;
import com.linecorp.centraldogma.common.Query;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CentralDogmaEndpointGroup<T>
extends DynamicEndpointGroup {
    private static final Logger logger = LoggerFactory.getLogger(CentralDogmaEndpointGroup.class);
    private final Watcher<T> instanceListWatcher;
    private final EndpointListDecoder<T> endpointListDecoder;

    public static <T> CentralDogmaEndpointGroup<T> ofWatcher(Watcher<T> watcher, EndpointListDecoder<T> endpointListDecoder) {
        return new CentralDogmaEndpointGroup<T>(EndpointSelectionStrategy.weightedRoundRobin(), watcher, endpointListDecoder);
    }

    public static <T> CentralDogmaEndpointGroup<T> of(CentralDogma centralDogma, String projectName, String repositoryName, Query<T> query, EndpointListDecoder<T> endpointListDecoder) {
        return CentralDogmaEndpointGroup.ofWatcher(centralDogma.forRepo(projectName, repositoryName).watcher(query).start(), endpointListDecoder);
    }

    public static <T> CentralDogmaEndpointGroupBuilder<T> builder(Watcher<T> watcher, EndpointListDecoder<T> endpointListDecoder) {
        return new CentralDogmaEndpointGroupBuilder<T>(watcher, endpointListDecoder);
    }

    CentralDogmaEndpointGroup(EndpointSelectionStrategy strategy, Watcher<T> instanceListWatcher, EndpointListDecoder<T> endpointListDecoder) {
        super(strategy);
        this.instanceListWatcher = Objects.requireNonNull(instanceListWatcher, "instanceListWatcher");
        this.endpointListDecoder = Objects.requireNonNull(endpointListDecoder, "endpointListDecoder");
        this.registerWatcher();
    }

    private void registerWatcher() {
        this.instanceListWatcher.watch((revision, instances) -> {
            try {
                List<Endpoint> newEndpoints = this.endpointListDecoder.decode(instances);
                if (newEndpoints.isEmpty()) {
                    logger.info("Not refreshing the endpoint list of {} because it's empty. {}", this.instanceListWatcher, revision);
                    return;
                }
                this.setEndpoints(newEndpoints);
            }
            catch (Exception e) {
                logger.warn("Failed to re-retrieve the endpoint list from Central Dogma.", (Throwable)e);
            }
        });
        this.instanceListWatcher.initialValueFuture().exceptionally(e -> {
            logger.warn("Failed to retrieve the initial instance list from Central Dogma.", e);
            return null;
        });
    }

    protected void doCloseAsync(CompletableFuture<?> future) {
        this.instanceListWatcher.close();
        future.complete(null);
    }
}

