/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.client.armeria;

import com.linecorp.armeria.client.ClientBuilder;
import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.WebClient;
import com.linecorp.armeria.client.encoding.DecodingClient;
import com.linecorp.armeria.client.endpoint.EndpointGroup;
import com.linecorp.centraldogma.client.CentralDogma;
import com.linecorp.centraldogma.client.armeria.AbstractArmeriaCentralDogmaBuilder;
import com.linecorp.centraldogma.client.armeria.ArmeriaCentralDogma;
import com.linecorp.centraldogma.internal.client.ReplicationLagTolerantCentralDogma;
import java.net.UnknownHostException;
import java.util.concurrent.ScheduledExecutorService;

public final class ArmeriaCentralDogmaBuilder
extends AbstractArmeriaCentralDogmaBuilder<ArmeriaCentralDogmaBuilder> {
    public CentralDogma build() throws UnknownHostException {
        EndpointGroup endpointGroup = this.endpointGroup();
        String scheme = "none+" + (this.isUseTls() ? "https" : "http");
        ClientBuilder builder = this.newClientBuilder(scheme, endpointGroup, cb -> cb.decorator(DecodingClient.newDecorator()), "/");
        int maxRetriesOnReplicationLag = this.maxNumRetriesOnReplicationLag();
        ScheduledExecutorService blockingTaskExecutor = this.blockingTaskExecutor();
        ArmeriaCentralDogma dogma = new ArmeriaCentralDogma(blockingTaskExecutor, (WebClient)builder.build(WebClient.class), this.accessToken());
        if (maxRetriesOnReplicationLag <= 0) {
            return dogma;
        }
        return new ReplicationLagTolerantCentralDogma(blockingTaskExecutor, (CentralDogma)dogma, maxRetriesOnReplicationLag, this.retryIntervalOnReplicationLagMillis(), () -> {
            ClientRequestContext ctx = ClientRequestContext.currentOrNull();
            return ctx != null ? ctx.remoteAddress() : null;
        });
    }
}

