/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.client.armeria;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.linecorp.armeria.client.Clients;
import com.linecorp.armeria.client.WebClient;
import com.linecorp.armeria.common.AggregatedHttpResponse;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.HttpStatusClass;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.RequestHeadersBuilder;
import com.linecorp.armeria.common.stream.ClosedStreamException;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.common.util.SafeCloseable;
import com.linecorp.armeria.common.util.TimeoutMode;
import com.linecorp.centraldogma.client.AbstractCentralDogma;
import com.linecorp.centraldogma.client.CentralDogmaRepository;
import com.linecorp.centraldogma.client.RepositoryInfo;
import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.common.AuthorizationException;
import com.linecorp.centraldogma.common.CentralDogmaException;
import com.linecorp.centraldogma.common.Change;
import com.linecorp.centraldogma.common.ChangeConflictException;
import com.linecorp.centraldogma.common.ChangeType;
import com.linecorp.centraldogma.common.Commit;
import com.linecorp.centraldogma.common.Entry;
import com.linecorp.centraldogma.common.EntryNotFoundException;
import com.linecorp.centraldogma.common.EntryType;
import com.linecorp.centraldogma.common.InvalidPushException;
import com.linecorp.centraldogma.common.Markup;
import com.linecorp.centraldogma.common.MergeQuery;
import com.linecorp.centraldogma.common.MergedEntry;
import com.linecorp.centraldogma.common.PathPattern;
import com.linecorp.centraldogma.common.ProjectExistsException;
import com.linecorp.centraldogma.common.ProjectNotFoundException;
import com.linecorp.centraldogma.common.PushResult;
import com.linecorp.centraldogma.common.Query;
import com.linecorp.centraldogma.common.QueryExecutionException;
import com.linecorp.centraldogma.common.QueryType;
import com.linecorp.centraldogma.common.RedundantChangeException;
import com.linecorp.centraldogma.common.RepositoryExistsException;
import com.linecorp.centraldogma.common.RepositoryNotFoundException;
import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.common.RevisionNotFoundException;
import com.linecorp.centraldogma.common.ShuttingDownException;
import com.linecorp.centraldogma.internal.Jackson;
import com.linecorp.centraldogma.internal.Util;
import com.linecorp.centraldogma.internal.api.v1.WatchTimeout;
import com.linecorp.centraldogma.internal.shaded.futures.CompletableFutures;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.internal.shaded.guava.base.Preconditions;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableMap;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableSet;
import com.linecorp.centraldogma.internal.shaded.guava.collect.Iterables;
import com.linecorp.centraldogma.internal.shaded.guava.collect.Streams;
import com.linecorp.centraldogma.internal.shaded.guava.math.LongMath;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;

final class ArmeriaCentralDogma
extends AbstractCentralDogma {
    private static final MediaType JSON_PATCH_UTF8 = MediaType.JSON_PATCH.withCharset(StandardCharsets.UTF_8);
    private static final byte[] UNREMOVE_PATCH = ArmeriaCentralDogma.toBytes((JsonNode)JsonNodeFactory.instance.arrayNode(1).add((JsonNode)JsonNodeFactory.instance.objectNode().put("op", "replace").put("path", "/status").put("value", "active")));
    private static final String REMOVED_PARAM = "?status=removed";
    private static final Map<String, Function<String, CentralDogmaException>> EXCEPTION_FACTORIES = ImmutableMap.builder().put((Object)ProjectExistsException.class.getName(), ProjectExistsException::new).put((Object)ProjectNotFoundException.class.getName(), ProjectNotFoundException::new).put((Object)QueryExecutionException.class.getName(), QueryExecutionException::new).put((Object)RedundantChangeException.class.getName(), RedundantChangeException::new).put((Object)RevisionNotFoundException.class.getName(), RevisionNotFoundException::new).put((Object)EntryNotFoundException.class.getName(), EntryNotFoundException::new).put((Object)ChangeConflictException.class.getName(), ChangeConflictException::new).put((Object)RepositoryNotFoundException.class.getName(), RepositoryNotFoundException::new).put((Object)AuthorizationException.class.getName(), AuthorizationException::new).put((Object)ShuttingDownException.class.getName(), ShuttingDownException::new).put((Object)RepositoryExistsException.class.getName(), RepositoryExistsException::new).put((Object)InvalidPushException.class.getName(), InvalidPushException::new).build();
    private final WebClient client;
    private final String authorization;

    ArmeriaCentralDogma(ScheduledExecutorService blockingTaskExecutor, WebClient client, String accessToken) {
        super(blockingTaskExecutor);
        this.client = Objects.requireNonNull(client, "client");
        this.authorization = "Bearer " + Objects.requireNonNull(accessToken, "accessToken");
    }

    public CompletableFuture<Void> whenEndpointReady() {
        return this.client.endpointGroup().whenReady().thenRun(() -> {});
    }

    public CompletableFuture<Void> createProject(String projectName) {
        ArmeriaCentralDogma.validateProjectName(projectName);
        try {
            ObjectNode root = JsonNodeFactory.instance.objectNode();
            root.put("name", projectName);
            return this.client.execute(this.headers(HttpMethod.POST, "/api/v1/projects"), ArmeriaCentralDogma.toBytes((JsonNode)root)).aggregate().thenApply(ArmeriaCentralDogma::createProject);
        }
        catch (Exception e) {
            return CompletableFutures.exceptionallyCompletedFuture((Throwable)e);
        }
    }

    private static Void createProject(AggregatedHttpResponse res) {
        switch (res.status().code()) {
            case 200: 
            case 201: {
                return null;
            }
        }
        return (Void)ArmeriaCentralDogma.handleErrorResponse(res);
    }

    public CompletableFuture<Void> removeProject(String projectName) {
        ArmeriaCentralDogma.validateProjectName(projectName);
        try {
            return this.client.execute(this.headers(HttpMethod.DELETE, ArmeriaCentralDogma.pathBuilder(projectName).toString())).aggregate().thenApply(ArmeriaCentralDogma::removeProject);
        }
        catch (Exception e) {
            return CompletableFutures.exceptionallyCompletedFuture((Throwable)e);
        }
    }

    private static Void removeProject(AggregatedHttpResponse res) {
        switch (res.status().code()) {
            case 200: 
            case 204: {
                return null;
            }
        }
        return (Void)ArmeriaCentralDogma.handleErrorResponse(res);
    }

    public CompletableFuture<Void> purgeProject(String projectName) {
        ArmeriaCentralDogma.validateProjectName(projectName);
        try {
            return this.client.execute(this.headers(HttpMethod.DELETE, ArmeriaCentralDogma.pathBuilder(projectName).append("/removed").toString())).aggregate().thenApply(ArmeriaCentralDogma::handlePurgeResult);
        }
        catch (Exception e) {
            return CompletableFutures.exceptionallyCompletedFuture((Throwable)e);
        }
    }

    public CompletableFuture<Void> unremoveProject(String projectName) {
        ArmeriaCentralDogma.validateProjectName(projectName);
        try {
            return this.client.execute(this.headers(HttpMethod.PATCH, ArmeriaCentralDogma.pathBuilder(projectName).toString()), UNREMOVE_PATCH).aggregate().thenApply(ArmeriaCentralDogma::unremoveProject);
        }
        catch (Exception e) {
            return CompletableFutures.exceptionallyCompletedFuture((Throwable)e);
        }
    }

    private static Void unremoveProject(AggregatedHttpResponse res) {
        if (res.status().code() == 200) {
            return null;
        }
        return (Void)ArmeriaCentralDogma.handleErrorResponse(res);
    }

    public CompletableFuture<Set<String>> listProjects() {
        return this.client.execute(this.headers(HttpMethod.GET, "/api/v1/projects")).aggregate().thenApply(ArmeriaCentralDogma::handleNameList);
    }

    public CompletableFuture<Set<String>> listRemovedProjects() {
        return this.client.execute(this.headers(HttpMethod.GET, "/api/v1/projects?status=removed")).aggregate().thenApply(ArmeriaCentralDogma::handleNameList);
    }

    public CompletableFuture<CentralDogmaRepository> createRepository(String projectName, String repositoryName) {
        ArmeriaCentralDogma.validateProjectAndRepositoryName(projectName, repositoryName);
        try {
            String path = ArmeriaCentralDogma.pathBuilder(projectName).append("/repos").toString();
            ObjectNode root = JsonNodeFactory.instance.objectNode();
            root.put("name", repositoryName);
            return this.client.execute(this.headers(HttpMethod.POST, path), ArmeriaCentralDogma.toBytes((JsonNode)root)).aggregate().thenApply(res -> {
                switch (res.status().code()) {
                    case 200: 
                    case 201: {
                        return this.forRepo(projectName, repositoryName);
                    }
                }
                return (CentralDogmaRepository)ArmeriaCentralDogma.handleErrorResponse(res);
            });
        }
        catch (Exception e) {
            return CompletableFutures.exceptionallyCompletedFuture((Throwable)e);
        }
    }

    public CompletableFuture<Void> removeRepository(String projectName, String repositoryName) {
        ArmeriaCentralDogma.validateProjectAndRepositoryName(projectName, repositoryName);
        try {
            return this.client.execute(this.headers(HttpMethod.DELETE, ArmeriaCentralDogma.pathBuilder(projectName, repositoryName).toString())).aggregate().thenApply(ArmeriaCentralDogma::removeRepository);
        }
        catch (Exception e) {
            return CompletableFutures.exceptionallyCompletedFuture((Throwable)e);
        }
    }

    private static Void removeRepository(AggregatedHttpResponse res) {
        switch (res.status().code()) {
            case 200: 
            case 204: {
                return null;
            }
        }
        return (Void)ArmeriaCentralDogma.handleErrorResponse(res);
    }

    public CompletableFuture<Void> purgeRepository(String projectName, String repositoryName) {
        ArmeriaCentralDogma.validateProjectAndRepositoryName(projectName, repositoryName);
        try {
            return this.client.execute(this.headers(HttpMethod.DELETE, ArmeriaCentralDogma.pathBuilder(projectName, repositoryName).append("/removed").toString())).aggregate().thenApply(ArmeriaCentralDogma::handlePurgeResult);
        }
        catch (Exception e) {
            return CompletableFutures.exceptionallyCompletedFuture((Throwable)e);
        }
    }

    private static Void handlePurgeResult(AggregatedHttpResponse res) {
        switch (res.status().code()) {
            case 200: 
            case 204: {
                return null;
            }
        }
        return (Void)ArmeriaCentralDogma.handleErrorResponse(res);
    }

    public CompletableFuture<CentralDogmaRepository> unremoveRepository(String projectName, String repositoryName) {
        ArmeriaCentralDogma.validateProjectAndRepositoryName(projectName, repositoryName);
        try {
            return this.client.execute(this.headers(HttpMethod.PATCH, ArmeriaCentralDogma.pathBuilder(projectName, repositoryName).toString()), UNREMOVE_PATCH).aggregate().thenApply(res -> {
                if (res.status().code() == 200) {
                    return this.forRepo(projectName, repositoryName);
                }
                return (CentralDogmaRepository)ArmeriaCentralDogma.handleErrorResponse(res);
            });
        }
        catch (Exception e) {
            return CompletableFutures.exceptionallyCompletedFuture((Throwable)e);
        }
    }

    public CompletableFuture<Map<String, RepositoryInfo>> listRepositories(String projectName) {
        ArmeriaCentralDogma.validateProjectName(projectName);
        try {
            return this.client.execute(this.headers(HttpMethod.GET, ArmeriaCentralDogma.pathBuilder(projectName).append("/repos").toString())).aggregate().thenApply(ArmeriaCentralDogma::listRepositories);
        }
        catch (Exception e) {
            return CompletableFutures.exceptionallyCompletedFuture((Throwable)e);
        }
    }

    private static Map<String, RepositoryInfo> listRepositories(AggregatedHttpResponse res) {
        switch (res.status().code()) {
            case 200: {
                return (Map)Streams.stream((Iterable)ArmeriaCentralDogma.toJson(res, JsonNodeType.ARRAY)).map(node -> {
                    String name = ArmeriaCentralDogma.getField(node, "name").asText();
                    Revision headRevision = new Revision(ArmeriaCentralDogma.getField(node, "headRevision").asInt());
                    return new RepositoryInfo(name, headRevision);
                }).collect(ImmutableMap.toImmutableMap(RepositoryInfo::name, Function.identity()));
            }
            case 204: {
                return ImmutableMap.of();
            }
        }
        return (Map)ArmeriaCentralDogma.handleErrorResponse(res);
    }

    public CompletableFuture<Set<String>> listRemovedRepositories(String projectName) {
        ArmeriaCentralDogma.validateProjectName(projectName);
        try {
            return this.client.execute(this.headers(HttpMethod.GET, ArmeriaCentralDogma.pathBuilder(projectName).append("/repos").append(REMOVED_PARAM).toString())).aggregate().thenApply(ArmeriaCentralDogma::handleNameList);
        }
        catch (Exception e) {
            return CompletableFutures.exceptionallyCompletedFuture((Throwable)e);
        }
    }

    public CompletableFuture<Revision> normalizeRevision(String projectName, String repositoryName, Revision revision) {
        ArmeriaCentralDogma.validateProjectAndRepositoryName(projectName, repositoryName);
        Objects.requireNonNull(revision, "revision");
        try {
            String path = ArmeriaCentralDogma.pathBuilder(projectName, repositoryName).append("/revision/").append(revision.text()).toString();
            return this.client.execute(this.headers(HttpMethod.GET, path)).aggregate().thenApply(ArmeriaCentralDogma::normalizeRevision);
        }
        catch (Exception e) {
            return CompletableFutures.exceptionallyCompletedFuture((Throwable)e);
        }
    }

    private static Revision normalizeRevision(AggregatedHttpResponse res) {
        if (res.status().code() == 200) {
            return new Revision(ArmeriaCentralDogma.getField(ArmeriaCentralDogma.toJson(res, JsonNodeType.OBJECT), "revision").asInt());
        }
        return (Revision)ArmeriaCentralDogma.handleErrorResponse(res);
    }

    public CompletableFuture<Map<String, EntryType>> listFiles(String projectName, String repositoryName, Revision revision, PathPattern pathPattern) {
        ArmeriaCentralDogma.validateProjectAndRepositoryName(projectName, repositoryName);
        Objects.requireNonNull(revision, "revision");
        Objects.requireNonNull(pathPattern, "pathPattern");
        try {
            StringBuilder path = ArmeriaCentralDogma.pathBuilder(projectName, repositoryName);
            path.append("/list").append(pathPattern.encoded()).append("?revision=").append(revision.major());
            return this.client.execute(this.headers(HttpMethod.GET, path.toString())).aggregate().thenApply(ArmeriaCentralDogma::listFiles);
        }
        catch (Exception e) {
            return CompletableFutures.exceptionallyCompletedFuture((Throwable)e);
        }
    }

    private static Map<String, EntryType> listFiles(AggregatedHttpResponse res) {
        switch (res.status().code()) {
            case 200: {
                ImmutableMap.Builder builder = ImmutableMap.builder();
                JsonNode node = ArmeriaCentralDogma.toJson(res, JsonNodeType.ARRAY);
                node.forEach(e -> builder.put((Object)ArmeriaCentralDogma.getField(e, "path").asText(), (Object)EntryType.valueOf((String)ArmeriaCentralDogma.getField(e, "type").asText())));
                return builder.build();
            }
            case 204: {
                return ImmutableMap.of();
            }
        }
        return (Map)ArmeriaCentralDogma.handleErrorResponse(res);
    }

    public <T> CompletableFuture<Entry<T>> getFile(String projectName, String repositoryName, Revision revision, Query<T> query) {
        ArmeriaCentralDogma.validateProjectAndRepositoryName(projectName, repositoryName);
        Objects.requireNonNull(revision, "revision");
        Objects.requireNonNull(query, "query");
        try {
            return this.maybeNormalizeRevision(projectName, repositoryName, revision).thenCompose(normRev -> {
                StringBuilder path = ArmeriaCentralDogma.pathBuilder(projectName, repositoryName);
                path.append("/contents").append(query.path());
                path.append("?revision=").append(normRev.text());
                ArmeriaCentralDogma.appendJsonPaths(path, query.type(), query.expressions());
                return this.client.execute(this.headers(HttpMethod.GET, path.toString())).aggregate().thenApply(res -> ArmeriaCentralDogma.getFile(normRev, res, query));
            });
        }
        catch (Exception e) {
            return CompletableFutures.exceptionallyCompletedFuture((Throwable)e);
        }
    }

    private static <T> Entry<T> getFile(Revision normRev, AggregatedHttpResponse res, Query<T> query) {
        if (res.status().code() == 200) {
            JsonNode node = ArmeriaCentralDogma.toJson(res, JsonNodeType.OBJECT);
            return ArmeriaCentralDogma.toEntry(normRev, node, query.type());
        }
        return (Entry)ArmeriaCentralDogma.handleErrorResponse(res);
    }

    public CompletableFuture<Map<String, Entry<?>>> getFiles(String projectName, String repositoryName, Revision revision, PathPattern pathPattern) {
        ArmeriaCentralDogma.validateProjectAndRepositoryName(projectName, repositoryName);
        Objects.requireNonNull(revision, "revision");
        Objects.requireNonNull(pathPattern, "pathPattern");
        try {
            return this.maybeNormalizeRevision(projectName, repositoryName, revision).thenCompose(normRev -> {
                StringBuilder path = ArmeriaCentralDogma.pathBuilder(projectName, repositoryName);
                path.append("/contents").append(pathPattern.encoded()).append("?revision=").append(normRev.major());
                return this.client.execute(this.headers(HttpMethod.GET, path.toString())).aggregate().thenApply(res -> ArmeriaCentralDogma.getFiles(normRev, res));
            });
        }
        catch (Exception e) {
            return CompletableFutures.exceptionallyCompletedFuture((Throwable)e);
        }
    }

    private static Map<String, Entry<?>> getFiles(Revision normRev, AggregatedHttpResponse res) {
        switch (res.status().code()) {
            case 200: {
                JsonNode node = ArmeriaCentralDogma.toJson(res, null);
                ImmutableMap.Builder builder = ImmutableMap.builder();
                if (node.isObject()) {
                    Entry entry = ArmeriaCentralDogma.toEntry(normRev, node, QueryType.IDENTITY);
                    builder.put((Object)entry.path(), entry);
                } else if (node.isArray()) {
                    node.forEach(e -> {
                        Entry entry = ArmeriaCentralDogma.toEntry(normRev, e, QueryType.IDENTITY);
                        builder.put((Object)entry.path(), entry);
                    });
                } else {
                    return (Map)ArmeriaCentralDogma.rejectNeitherArrayNorObject(res);
                }
                return builder.build();
            }
            case 204: {
                return ImmutableMap.of();
            }
        }
        return (Map)ArmeriaCentralDogma.handleErrorResponse(res);
    }

    public <T> CompletableFuture<MergedEntry<T>> mergeFiles(String projectName, String repositoryName, Revision revision, MergeQuery<T> mergeQuery) {
        ArmeriaCentralDogma.validateProjectAndRepositoryName(projectName, repositoryName);
        Objects.requireNonNull(revision, "revision");
        Objects.requireNonNull(mergeQuery, "mergeQuery");
        try {
            StringBuilder path = ArmeriaCentralDogma.pathBuilder(projectName, repositoryName);
            path.append("/merge?revision=").append(revision.major());
            mergeQuery.mergeSources().forEach(src -> path.append(src.isOptional() ? "&optional_path=" : "&path=").append(ArmeriaCentralDogma.encodeParam(src.path())));
            ArmeriaCentralDogma.appendJsonPaths(path, mergeQuery.type(), mergeQuery.expressions());
            return this.client.execute(this.headers(HttpMethod.GET, path.toString())).aggregate().thenApply(ArmeriaCentralDogma::mergeFiles);
        }
        catch (Exception e) {
            return CompletableFutures.exceptionallyCompletedFuture((Throwable)e);
        }
    }

    private static <T> MergedEntry<T> mergeFiles(AggregatedHttpResponse res) {
        if (res.status().code() == 200) {
            JsonNode node = ArmeriaCentralDogma.toJson(res, JsonNodeType.OBJECT);
            ImmutableList.Builder pathsBuilder = ImmutableList.builder();
            for (JsonNode path : ArmeriaCentralDogma.getField(node, "paths")) {
                if (path.getNodeType() != JsonNodeType.STRING) {
                    throw new CentralDogmaException("Received a merged entry with a non-string path: " + node);
                }
                pathsBuilder.add((Object)path.asText());
            }
            ImmutableList paths = pathsBuilder.build();
            if (paths.isEmpty()) {
                throw new CentralDogmaException("Received a merged entry with empty paths: " + node);
            }
            Revision revision = new Revision(ArmeriaCentralDogma.getField(node, "revision").asInt());
            EntryType type = EntryType.valueOf((String)ArmeriaCentralDogma.getField(node, "type").asText());
            JsonNode content = ArmeriaCentralDogma.getField(node, "content");
            switch (type) {
                case JSON: {
                    MergedEntry cast = MergedEntry.of((Revision)revision, (EntryType)type, (Object)content, (Iterable)paths);
                    return cast;
                }
                case TEXT: {
                    if (content.getNodeType() != JsonNodeType.STRING) {
                        throw new CentralDogmaException("Received a TEXT merged entry whose content is not a string: " + node);
                    }
                    MergedEntry cast = MergedEntry.of((Revision)revision, (EntryType)type, (Object)content.asText(), (Iterable)paths);
                    return cast;
                }
            }
            throw new CentralDogmaException("Received a merged entry whose type is neither JSON nor TEXT: " + node);
        }
        return (MergedEntry)ArmeriaCentralDogma.handleErrorResponse(res);
    }

    public CompletableFuture<List<Commit>> getHistory(String projectName, String repositoryName, Revision from, Revision to, PathPattern pathPattern, int maxCommits) {
        Objects.requireNonNull(from, "from");
        Objects.requireNonNull(to, "to");
        Objects.requireNonNull(pathPattern, "pathPattern");
        ArmeriaCentralDogma.validateProjectAndRepositoryName(projectName, repositoryName);
        Preconditions.checkArgument((maxCommits >= 0 && maxCommits <= 1000 ? 1 : 0) != 0, (String)"maxCommits: %s (expected: 0 <= maxCommits <= %s)", (int)maxCommits, (int)1000);
        try {
            StringBuilder path = ArmeriaCentralDogma.pathBuilder(projectName, repositoryName);
            path.append("/commits/").append(from.text());
            path.append("?to=").append(to.text());
            path.append("&path=").append(pathPattern.encoded());
            if (maxCommits > 0) {
                path.append("&maxCommits=").append(maxCommits);
            }
            return this.client.execute(this.headers(HttpMethod.GET, path.toString())).aggregate().thenApply(ArmeriaCentralDogma::getHistory);
        }
        catch (Exception e) {
            return CompletableFutures.exceptionallyCompletedFuture((Throwable)e);
        }
    }

    private static List<Commit> getHistory(AggregatedHttpResponse res) {
        switch (res.status().code()) {
            case 200: {
                JsonNode node = ArmeriaCentralDogma.toJson(res, null);
                if (node.isObject()) {
                    return ImmutableList.of((Object)ArmeriaCentralDogma.toCommit(node));
                }
                if (node.isArray()) {
                    return (List)Streams.stream((Iterable)node).map(ArmeriaCentralDogma::toCommit).collect(ImmutableList.toImmutableList());
                }
                return (List)ArmeriaCentralDogma.rejectNeitherArrayNorObject(res);
            }
            case 204: {
                return ImmutableList.of();
            }
        }
        return (List)ArmeriaCentralDogma.handleErrorResponse(res);
    }

    public <T> CompletableFuture<Change<T>> getDiff(String projectName, String repositoryName, Revision from, Revision to, Query<T> query) {
        ArmeriaCentralDogma.validateProjectAndRepositoryName(projectName, repositoryName);
        Objects.requireNonNull(from, "from");
        Objects.requireNonNull(to, "to");
        Objects.requireNonNull(query, "query");
        try {
            StringBuilder path = ArmeriaCentralDogma.pathBuilder(projectName, repositoryName);
            path.append("/compare");
            path.append("?path=").append(ArmeriaCentralDogma.encodeParam(query.path()));
            path.append("&from=").append(from.text());
            path.append("&to=").append(to.text());
            ArmeriaCentralDogma.appendJsonPaths(path, query.type(), query.expressions());
            return this.client.execute(this.headers(HttpMethod.GET, path.toString())).aggregate().thenApply(ArmeriaCentralDogma::getDiff);
        }
        catch (Exception e) {
            return CompletableFutures.exceptionallyCompletedFuture((Throwable)e);
        }
    }

    @Nullable
    private static <T> Change<T> getDiff(AggregatedHttpResponse res) {
        switch (res.status().code()) {
            case 200: {
                return ArmeriaCentralDogma.toChange(ArmeriaCentralDogma.toJson(res, JsonNodeType.OBJECT));
            }
            case 204: {
                return null;
            }
        }
        return (Change)ArmeriaCentralDogma.handleErrorResponse(res);
    }

    public CompletableFuture<List<Change<?>>> getDiff(String projectName, String repositoryName, Revision from, Revision to, PathPattern pathPattern) {
        ArmeriaCentralDogma.validateProjectAndRepositoryName(projectName, repositoryName);
        Objects.requireNonNull(from, "from");
        Objects.requireNonNull(to, "to");
        Objects.requireNonNull(pathPattern, "pathPattern");
        try {
            StringBuilder path = ArmeriaCentralDogma.pathBuilder(projectName, repositoryName);
            path.append("/compare");
            path.append("?pathPattern=").append(pathPattern.encoded());
            path.append("&from=").append(from.text());
            path.append("&to=").append(to.text());
            return this.client.execute(this.headers(HttpMethod.GET, path.toString())).aggregate().thenApply(res -> {
                if (res.status().code() == 200) {
                    JsonNode node = ArmeriaCentralDogma.toJson(res, null);
                    if (node.isObject()) {
                        return ImmutableList.of(ArmeriaCentralDogma.toChange(node));
                    }
                    if (node.isArray()) {
                        return (List)Streams.stream((Iterable)node).map(ArmeriaCentralDogma::toChange).collect(ImmutableList.toImmutableList());
                    }
                    return (List)ArmeriaCentralDogma.rejectNeitherArrayNorObject(res);
                }
                return (List)ArmeriaCentralDogma.handleErrorResponse(res);
            });
        }
        catch (Exception e) {
            return CompletableFutures.exceptionallyCompletedFuture((Throwable)e);
        }
    }

    public CompletableFuture<List<Change<?>>> getPreviewDiffs(String projectName, String repositoryName, Revision baseRevision, Iterable<? extends Change<?>> changes) {
        ArmeriaCentralDogma.validateProjectAndRepositoryName(projectName, repositoryName);
        Objects.requireNonNull(baseRevision, "baseRevision");
        Objects.requireNonNull(changes, "changes");
        try {
            String path = ArmeriaCentralDogma.pathBuilder(projectName, repositoryName).append("/preview?revision=").append(baseRevision.text()).toString();
            ArrayNode changesNode = ArmeriaCentralDogma.toJson(changes);
            return this.client.execute(this.headers(HttpMethod.POST, path), ArmeriaCentralDogma.toBytes((JsonNode)changesNode)).aggregate().thenApply(ArmeriaCentralDogma::getPreviewDiffs);
        }
        catch (Exception e) {
            return CompletableFutures.exceptionallyCompletedFuture((Throwable)e);
        }
    }

    private static List<Change<?>> getPreviewDiffs(AggregatedHttpResponse res) {
        switch (res.status().code()) {
            case 200: {
                JsonNode node = ArmeriaCentralDogma.toJson(res, JsonNodeType.ARRAY);
                ImmutableList.Builder builder = ImmutableList.builder();
                node.forEach(e -> builder.add(ArmeriaCentralDogma.toChange(e)));
                return builder.build();
            }
            case 204: {
                return ImmutableList.of();
            }
        }
        return (List)ArmeriaCentralDogma.handleErrorResponse(res);
    }

    public CompletableFuture<PushResult> push(String projectName, String repositoryName, Revision baseRevision, String summary, String detail, Markup markup, Iterable<? extends Change<?>> changes) {
        ArmeriaCentralDogma.validateProjectAndRepositoryName(projectName, repositoryName);
        Objects.requireNonNull(baseRevision, "baseRevision");
        Objects.requireNonNull(summary, "summary");
        Preconditions.checkArgument((!summary.isEmpty() ? 1 : 0) != 0, (Object)"summary is empty.");
        Objects.requireNonNull(markup, "markup");
        Objects.requireNonNull(changes, "changes");
        Preconditions.checkArgument((!Iterables.isEmpty(changes) ? 1 : 0) != 0, (Object)"changes is empty.");
        try {
            String path = ArmeriaCentralDogma.pathBuilder(projectName, repositoryName).append("/contents?revision=").append(baseRevision.text()).toString();
            ObjectNode commitNode = JsonNodeFactory.instance.objectNode();
            commitNode.set("commitMessage", (JsonNode)JsonNodeFactory.instance.objectNode().put("summary", summary).put("detail", detail).put("markup", markup.name()));
            commitNode.set("changes", (JsonNode)ArmeriaCentralDogma.toJson(changes));
            return this.client.execute(this.headers(HttpMethod.POST, path), ArmeriaCentralDogma.toBytes((JsonNode)commitNode)).aggregate().thenApply(ArmeriaCentralDogma::push);
        }
        catch (Exception e) {
            return CompletableFutures.exceptionallyCompletedFuture((Throwable)e);
        }
    }

    private static PushResult push(AggregatedHttpResponse res) {
        if (res.status().code() == 200) {
            JsonNode node = ArmeriaCentralDogma.toJson(res, JsonNodeType.OBJECT);
            return new PushResult(new Revision(ArmeriaCentralDogma.getField(node, "revision").asInt()), Instant.parse(ArmeriaCentralDogma.getField(node, "pushedAt").asText()).toEpochMilli());
        }
        return (PushResult)ArmeriaCentralDogma.handleErrorResponse(res);
    }

    public CompletableFuture<PushResult> push(String projectName, String repositoryName, Revision baseRevision, Author author, String summary, String detail, Markup markup, Iterable<? extends Change<?>> changes) {
        return this.push(projectName, repositoryName, baseRevision, summary, detail, markup, changes);
    }

    public CompletableFuture<Revision> watchRepository(String projectName, String repositoryName, Revision lastKnownRevision, PathPattern pathPattern, long timeoutMillis, boolean errorOnEntryNotFound) {
        ArmeriaCentralDogma.validateProjectAndRepositoryName(projectName, repositoryName);
        Objects.requireNonNull(lastKnownRevision, "lastKnownRevision");
        Objects.requireNonNull(pathPattern, "pathPattern");
        Preconditions.checkArgument((timeoutMillis > 0L ? 1 : 0) != 0, (String)"timeoutMillis: %s (expected: > 0)", (long)timeoutMillis);
        try {
            StringBuilder path = ArmeriaCentralDogma.pathBuilder(projectName, repositoryName);
            path.append("/contents").append(pathPattern.encoded());
            return this.watch(lastKnownRevision, timeoutMillis, path.toString(), QueryType.IDENTITY, ArmeriaCentralDogma::watchRepository, errorOnEntryNotFound);
        }
        catch (Exception e) {
            return CompletableFutures.exceptionallyCompletedFuture((Throwable)e);
        }
    }

    @Nullable
    private static Revision watchRepository(AggregatedHttpResponse res, QueryType unused) {
        switch (res.status().code()) {
            case 200: {
                JsonNode node = ArmeriaCentralDogma.toJson(res, JsonNodeType.OBJECT);
                return new Revision(ArmeriaCentralDogma.getField(node, "revision").asInt());
            }
            case 304: {
                return null;
            }
        }
        return (Revision)ArmeriaCentralDogma.handleErrorResponse(res);
    }

    public <T> CompletableFuture<Entry<T>> watchFile(String projectName, String repositoryName, Revision lastKnownRevision, Query<T> query, long timeoutMillis, boolean errorOnEntryNotFound) {
        ArmeriaCentralDogma.validateProjectAndRepositoryName(projectName, repositoryName);
        Objects.requireNonNull(lastKnownRevision, "lastKnownRevision");
        Objects.requireNonNull(query, "query");
        Preconditions.checkArgument((timeoutMillis > 0L ? 1 : 0) != 0, (String)"timeoutMillis: %s (expected: > 0)", (long)timeoutMillis);
        try {
            StringBuilder path = ArmeriaCentralDogma.pathBuilder(projectName, repositoryName);
            path.append("/contents").append(query.path());
            if (query.type() == QueryType.JSON_PATH) {
                path.append('?');
                query.expressions().forEach(expr -> path.append("jsonpath=").append(ArmeriaCentralDogma.encodeParam(expr)).append('&'));
                path.setLength(path.length() - 1);
            }
            return this.watch(lastKnownRevision, timeoutMillis, path.toString(), query.type(), ArmeriaCentralDogma::watchFile, errorOnEntryNotFound);
        }
        catch (Exception e) {
            return CompletableFutures.exceptionallyCompletedFuture((Throwable)e);
        }
    }

    @Nullable
    private static <T> Entry<T> watchFile(AggregatedHttpResponse res, QueryType queryType) {
        switch (res.status().code()) {
            case 200: {
                JsonNode node = ArmeriaCentralDogma.toJson(res, JsonNodeType.OBJECT);
                Revision revision = new Revision(ArmeriaCentralDogma.getField(node, "revision").asInt());
                return ArmeriaCentralDogma.toEntry(revision, ArmeriaCentralDogma.getField(node, "entry"), queryType);
            }
            case 304: {
                return null;
            }
        }
        return (Entry)ArmeriaCentralDogma.handleErrorResponse(res);
    }

    private <T> CompletableFuture<T> watch(Revision lastKnownRevision, long timeoutMillis, String path, QueryType queryType, BiFunction<AggregatedHttpResponse, QueryType, T> func, boolean errorOnEntryNotFound) {
        RequestHeadersBuilder builder = this.headersBuilder(HttpMethod.GET, path);
        builder.set((CharSequence)HttpHeaderNames.IF_NONE_MATCH, lastKnownRevision.text()).set((CharSequence)HttpHeaderNames.PREFER, "wait=" + LongMath.saturatedAdd((long)timeoutMillis, (long)999L) / 1000L + ", notify-entry-not-found=" + errorOnEntryNotFound);
        try (SafeCloseable ignored = Clients.withContextCustomizer(ctx -> {
            long responseTimeoutMillis = ctx.responseTimeoutMillis();
            long adjustmentMillis = WatchTimeout.availableTimeout((long)timeoutMillis, (long)responseTimeoutMillis);
            if (responseTimeoutMillis > 0L) {
                ctx.setResponseTimeoutMillis(TimeoutMode.EXTEND, adjustmentMillis);
            } else {
                ctx.setResponseTimeoutMillis(adjustmentMillis);
            }
        });){
            CompletionStage completionStage = this.client.execute(builder.build()).aggregate().handle((res, cause) -> {
                if (cause == null) {
                    return func.apply((AggregatedHttpResponse)res, queryType);
                }
                if (cause instanceof ClosedStreamException && this.client.options().factory().isClosing()) {
                    return null;
                }
                return Exceptions.throwUnsafely((Throwable)cause);
            });
            return completionStage;
        }
    }

    private static void validateProjectName(String projectName) {
        Util.validateProjectName((String)projectName, (String)"projectName");
    }

    private static void validateProjectAndRepositoryName(String projectName, String repositoryName) {
        ArmeriaCentralDogma.validateProjectName(projectName);
        Util.validateRepositoryName((String)repositoryName, (String)"repositoryName");
    }

    private RequestHeaders headers(HttpMethod method, String path) {
        return this.headersBuilder(method, path).build();
    }

    private RequestHeadersBuilder headersBuilder(HttpMethod method, String path) {
        RequestHeadersBuilder builder = RequestHeaders.builder();
        builder.method(method).path(path).set((CharSequence)HttpHeaderNames.AUTHORIZATION, this.authorization).setObject((CharSequence)HttpHeaderNames.ACCEPT, (Object)MediaType.JSON);
        switch (method) {
            case POST: 
            case PUT: {
                builder.contentType(MediaType.JSON_UTF_8);
                break;
            }
            case PATCH: {
                builder.contentType(JSON_PATCH_UTF8);
            }
        }
        return builder;
    }

    private static StringBuilder pathBuilder(String projectName) {
        return new StringBuilder().append("/api/v1/projects").append('/').append(projectName);
    }

    private static StringBuilder pathBuilder(String projectName, String repositoryName) {
        return ArmeriaCentralDogma.pathBuilder(projectName).append("/repos").append('/').append(repositoryName);
    }

    private static void appendJsonPaths(StringBuilder path, QueryType queryType, Iterable<String> expressions) {
        if (queryType == QueryType.JSON_PATH) {
            expressions.forEach(expr -> path.append("&jsonpath=").append(ArmeriaCentralDogma.encodeParam(expr)));
        }
    }

    private static String encodeParam(String param) {
        try {
            return URLEncoder.encode(param, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new Error();
        }
    }

    private static byte[] toBytes(JsonNode content) {
        try {
            return Jackson.writeValueAsBytes((Object)content);
        }
        catch (JsonProcessingException e) {
            throw new Error(e);
        }
    }

    private static ArrayNode toJson(Iterable<? extends Change<?>> changes) {
        ArrayNode changesNode = JsonNodeFactory.instance.arrayNode();
        changes.forEach(c -> {
            ObjectNode changeNode = JsonNodeFactory.instance.objectNode();
            changeNode.put("path", c.path());
            changeNode.put("type", c.type().name());
            Class contentType = c.type().contentType();
            if (contentType == JsonNode.class) {
                changeNode.set("content", (JsonNode)c.content());
            } else if (contentType == String.class) {
                changeNode.put("content", (String)c.content());
            }
            changesNode.add((JsonNode)changeNode);
        });
        return changesNode;
    }

    private static JsonNode toJson(AggregatedHttpResponse res, @Nullable JsonNodeType expectedNodeType) {
        JsonNode node;
        String content = ArmeriaCentralDogma.toString(res);
        try {
            node = Jackson.readTree((String)content);
        }
        catch (JsonParseException e) {
            throw new CentralDogmaException("failed to parse the response JSON", (Throwable)e);
        }
        if (expectedNodeType != null && node.getNodeType() != expectedNodeType) {
            throw new CentralDogmaException("invalid server response; expected: " + expectedNodeType + ", actual: " + node.getNodeType() + ", content: " + content);
        }
        return node;
    }

    private static <T> T rejectNeitherArrayNorObject(AggregatedHttpResponse res) {
        throw new CentralDogmaException("invalid server response; expected: " + JsonNodeType.OBJECT + " or " + JsonNodeType.ARRAY + ", content: " + ArmeriaCentralDogma.toString(res));
    }

    private static String toString(AggregatedHttpResponse res) {
        MediaType contentType = (MediaType)MoreObjects.firstNonNull((Object)res.headers().contentType(), (Object)MediaType.JSON_UTF_8);
        Charset charset = contentType.charset(StandardCharsets.UTF_8);
        return res.content(charset);
    }

    private static <T> Entry<T> toEntry(Revision revision, JsonNode node, QueryType queryType) {
        String entryPath = ArmeriaCentralDogma.getField(node, "path").asText();
        EntryType receivedEntryType = EntryType.valueOf((String)ArmeriaCentralDogma.getField(node, "type").asText());
        switch (queryType) {
            case IDENTITY_TEXT: {
                return ArmeriaCentralDogma.entryAsText(revision, node, entryPath);
            }
            case IDENTITY_JSON: 
            case JSON_PATH: {
                if (receivedEntryType != EntryType.JSON) {
                    throw new CentralDogmaException("invalid entry type. entry type: " + receivedEntryType + " (expected: " + queryType + ')');
                }
                return ArmeriaCentralDogma.entryAsJson(revision, node, entryPath);
            }
            case IDENTITY: {
                switch (receivedEntryType) {
                    case JSON: {
                        return ArmeriaCentralDogma.entryAsJson(revision, node, entryPath);
                    }
                    case TEXT: {
                        return ArmeriaCentralDogma.entryAsText(revision, node, entryPath);
                    }
                    case DIRECTORY: {
                        return (Entry)Util.unsafeCast((Object)Entry.ofDirectory((Revision)revision, (String)entryPath));
                    }
                }
            }
        }
        throw new Error();
    }

    private static <T> Entry<T> entryAsText(Revision revision, JsonNode node, String entryPath) {
        JsonNode content = ArmeriaCentralDogma.getField(node, "content");
        String content0 = content.isContainerNode() ? content.toString() : content.asText();
        return (Entry)Util.unsafeCast((Object)Entry.ofText((Revision)revision, (String)entryPath, (String)content0));
    }

    private static <T> Entry<T> entryAsJson(Revision revision, JsonNode node, String entryPath) {
        return (Entry)Util.unsafeCast((Object)Entry.ofJson((Revision)revision, (String)entryPath, (JsonNode)ArmeriaCentralDogma.getField(node, "content")));
    }

    private static Commit toCommit(JsonNode node) {
        Revision revision = new Revision(ArmeriaCentralDogma.getField(node, "revision").asInt());
        JsonNode authorNode = ArmeriaCentralDogma.getField(node, "author");
        Author author = new Author(ArmeriaCentralDogma.getField(authorNode, "name").asText(), ArmeriaCentralDogma.getField(authorNode, "email").asText());
        long pushedAt = Instant.from(DateTimeFormatter.ISO_INSTANT.parse(ArmeriaCentralDogma.getField(node, "pushedAt").asText())).toEpochMilli();
        JsonNode commitMessageNode = ArmeriaCentralDogma.getField(node, "commitMessage");
        String summary = ArmeriaCentralDogma.getField(commitMessageNode, "summary").asText();
        String detail = ArmeriaCentralDogma.getField(commitMessageNode, "detail").asText();
        Markup markup = Markup.valueOf((String)ArmeriaCentralDogma.getField(commitMessageNode, "markup").asText());
        return new Commit(revision, author, pushedAt, summary, detail, markup);
    }

    private static <T> Change<T> toChange(JsonNode node) {
        String actualPath = ArmeriaCentralDogma.getField(node, "path").asText();
        ChangeType type = ChangeType.valueOf((String)ArmeriaCentralDogma.getField(node, "type").asText());
        switch (type) {
            case UPSERT_JSON: {
                return (Change)Util.unsafeCast((Object)Change.ofJsonUpsert((String)actualPath, (JsonNode)ArmeriaCentralDogma.getField(node, "content")));
            }
            case UPSERT_TEXT: {
                return (Change)Util.unsafeCast((Object)Change.ofTextUpsert((String)actualPath, (String)ArmeriaCentralDogma.getField(node, "content").asText()));
            }
            case REMOVE: {
                return (Change)Util.unsafeCast((Object)Change.ofRemoval((String)actualPath));
            }
            case RENAME: {
                return (Change)Util.unsafeCast((Object)Change.ofRename((String)actualPath, (String)ArmeriaCentralDogma.getField(node, "content").asText()));
            }
            case APPLY_JSON_PATCH: {
                return (Change)Util.unsafeCast((Object)Change.ofJsonPatch((String)actualPath, (JsonNode)ArmeriaCentralDogma.getField(node, "content")));
            }
            case APPLY_TEXT_PATCH: {
                return (Change)Util.unsafeCast((Object)Change.ofTextPatch((String)actualPath, (String)ArmeriaCentralDogma.getField(node, "content").asText()));
            }
        }
        throw new Error();
    }

    private static Set<String> handleNameList(AggregatedHttpResponse res) {
        switch (res.status().code()) {
            case 200: {
                return (Set)Streams.stream((Iterable)ArmeriaCentralDogma.toJson(res, JsonNodeType.ARRAY)).map(node -> ArmeriaCentralDogma.getField(node, "name").asText()).collect(ImmutableSet.toImmutableSet());
            }
            case 204: {
                return ImmutableSet.of();
            }
        }
        return (Set)ArmeriaCentralDogma.handleErrorResponse(res);
    }

    private static JsonNode getField(JsonNode node, String fieldName) {
        JsonNode field = node.get(fieldName);
        if (field == null) {
            throw new CentralDogmaException("invalid server response; field '" + fieldName + "' does not exist: " + node);
        }
        return field;
    }

    private static <T> T handleErrorResponse(AggregatedHttpResponse res) {
        HttpStatus status = res.status();
        if (status.codeClass() != HttpStatusClass.SUCCESS) {
            Function<String, CentralDogmaException> exceptionFactory;
            String typeName;
            JsonNode node = ArmeriaCentralDogma.toJson(res, JsonNodeType.OBJECT);
            JsonNode exceptionNode = node.get("exception");
            JsonNode messageNode = node.get("message");
            if (exceptionNode != null && (typeName = exceptionNode.textValue()) != null && (exceptionFactory = EXCEPTION_FACTORIES.get(typeName)) != null) {
                throw exceptionFactory.apply(messageNode.textValue());
            }
        }
        throw new CentralDogmaException("unexpected response: " + res.headers() + ", " + res.contentUtf8());
    }
}

