/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.client.armeria;

import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.client.endpoint.DynamicEndpointGroup;
import com.linecorp.armeria.client.endpoint.EndpointGroup;
import com.linecorp.armeria.client.endpoint.EndpointSelectionStrategy;
import com.linecorp.armeria.common.util.AsyncCloseable;
import com.linecorp.centraldogma.internal.shaded.guava.annotations.VisibleForTesting;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableSortedSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

final class CompositeEndpointGroup
extends DynamicEndpointGroup {
    private final List<EndpointGroup> groups;

    CompositeEndpointGroup(Iterable<EndpointGroup> groups, EndpointSelectionStrategy selectionStrategy) {
        super(Objects.requireNonNull(selectionStrategy, "selectionStrategy"));
        this.groups = ImmutableList.copyOf(Objects.requireNonNull(groups, "groups"));
        this.groups.forEach(g -> g.addListener(this::onEndpointUpdate));
        Set<Endpoint> initialEndpoints = this.collectEndpoints();
        if (!initialEndpoints.isEmpty()) {
            this.setEndpoints(initialEndpoints);
        }
    }

    @VisibleForTesting
    List<EndpointGroup> groups() {
        return this.groups;
    }

    private void onEndpointUpdate(List<Endpoint> unused) {
        this.setEndpoints(this.collectEndpoints());
    }

    private Set<Endpoint> collectEndpoints() {
        ImmutableSortedSet.Builder initialEndpointsBuilder = ImmutableSortedSet.naturalOrder();
        this.groups.forEach(g -> initialEndpointsBuilder.addAll((Iterable)g.endpoints()));
        return initialEndpointsBuilder.build();
    }

    protected void doCloseAsync(CompletableFuture<?> future) {
        try {
            this.groups.forEach(AsyncCloseable::close);
        }
        finally {
            future.complete(null);
        }
    }
}

