/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.client;

import com.linecorp.centraldogma.client.CentralDogma;
import com.linecorp.centraldogma.client.CentralDogmaRepository;
import com.linecorp.centraldogma.client.Watcher;
import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.common.Change;
import com.linecorp.centraldogma.common.Commit;
import com.linecorp.centraldogma.common.Entry;
import com.linecorp.centraldogma.common.Markup;
import com.linecorp.centraldogma.common.MergeSource;
import com.linecorp.centraldogma.common.MergedEntry;
import com.linecorp.centraldogma.common.PushResult;
import com.linecorp.centraldogma.common.Query;
import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.internal.PathPatternUtil;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;

public abstract class AbstractCentralDogma
implements CentralDogma {
    private final ScheduledExecutorService blockingTaskExecutor;

    protected AbstractCentralDogma(ScheduledExecutorService blockingTaskExecutor) {
        this.blockingTaskExecutor = Objects.requireNonNull(blockingTaskExecutor, "blockingTaskExecutor");
    }

    protected final ScheduledExecutorService executor() {
        return this.blockingTaskExecutor;
    }

    @Override
    public CentralDogmaRepository forRepo(String projectName, String repositoryName) {
        Objects.requireNonNull(projectName, "projectName");
        Objects.requireNonNull(repositoryName, "repositoryName");
        return new CentralDogmaRepository(this, projectName, repositoryName, this.blockingTaskExecutor);
    }

    @Override
    public final CompletableFuture<Entry<?>> getFile(String projectName, String repositoryName, Revision revision, String path) {
        return CentralDogma.super.getFile(projectName, repositoryName, revision, path);
    }

    @Override
    public final CompletableFuture<MergedEntry<?>> mergeFiles(String projectName, String repositoryName, Revision revision, MergeSource ... mergeSources) {
        return CentralDogma.super.mergeFiles(projectName, repositoryName, revision, mergeSources);
    }

    @Override
    public final CompletableFuture<MergedEntry<?>> mergeFiles(String projectName, String repositoryName, Revision revision, Iterable<MergeSource> mergeSources) {
        return CentralDogma.super.mergeFiles(projectName, repositoryName, revision, mergeSources);
    }

    @Override
    public final CompletableFuture<List<Commit>> getHistory(String projectName, String repositoryName, Revision from, Revision to) {
        return CentralDogma.super.getHistory(projectName, repositoryName, from, to);
    }

    @Override
    public final CompletableFuture<Change<?>> getDiff(String projectName, String repositoryName, Revision from, Revision to, String path) {
        return CentralDogma.super.getDiff(projectName, repositoryName, from, to, path);
    }

    @Override
    public final CompletableFuture<List<Change<?>>> getPreviewDiffs(String projectName, String repositoryName, Revision baseRevision, Change<?> ... changes) {
        return CentralDogma.super.getPreviewDiffs(projectName, repositoryName, baseRevision, changes);
    }

    @Override
    public final CompletableFuture<PushResult> push(String projectName, String repositoryName, Revision baseRevision, String summary, Change<?> ... changes) {
        return CentralDogma.super.push(projectName, repositoryName, baseRevision, summary, changes);
    }

    @Override
    public final CompletableFuture<PushResult> push(String projectName, String repositoryName, Revision baseRevision, String summary, Iterable<? extends Change<?>> changes) {
        return CentralDogma.super.push(projectName, repositoryName, baseRevision, summary, changes);
    }

    @Override
    public final CompletableFuture<PushResult> push(String projectName, String repositoryName, Revision baseRevision, String summary, String detail, Markup markup, Change<?> ... changes) {
        return CentralDogma.super.push(projectName, repositoryName, baseRevision, summary, detail, markup, changes);
    }

    @Override
    public final CompletableFuture<PushResult> push(String projectName, String repositoryName, Revision baseRevision, Author author, String summary, Change<?> ... changes) {
        return CentralDogma.super.push(projectName, repositoryName, baseRevision, author, summary, changes);
    }

    @Override
    public final CompletableFuture<PushResult> push(String projectName, String repositoryName, Revision baseRevision, Author author, String summary, Iterable<? extends Change<?>> changes) {
        return CentralDogma.super.push(projectName, repositoryName, baseRevision, author, summary, changes);
    }

    @Override
    public final CompletableFuture<PushResult> push(String projectName, String repositoryName, Revision baseRevision, Author author, String summary, String detail, Markup markup, Change<?> ... changes) {
        return CentralDogma.super.push(projectName, repositoryName, baseRevision, author, summary, detail, markup, changes);
    }

    @Override
    public <T, U> Watcher<U> fileWatcher(String projectName, String repositoryName, Query<T> query, Function<? super T, ? extends U> function) {
        return this.fileWatcher(projectName, repositoryName, query, function, this.blockingTaskExecutor);
    }

    @Override
    public <T, U> Watcher<U> fileWatcher(String projectName, String repositoryName, Query<T> query, Function<? super T, ? extends U> function, Executor executor) {
        return this.forRepo(projectName, repositoryName).watcher(query).map(function).mapperExecutor(executor).start();
    }

    @Override
    public <T> Watcher<T> repositoryWatcher(String projectName, String repositoryName, String pathPattern, Function<Revision, ? extends T> function) {
        return this.repositoryWatcher(projectName, repositoryName, pathPattern, function, this.blockingTaskExecutor);
    }

    @Override
    public <T> Watcher<T> repositoryWatcher(String projectName, String repositoryName, String pathPattern, Function<Revision, ? extends T> function, Executor executor) {
        return this.forRepo(projectName, repositoryName).watcher(PathPatternUtil.toPathPattern((String)pathPattern)).map(function).mapperExecutor(executor).start();
    }

    protected final CompletableFuture<Revision> maybeNormalizeRevision(String projectName, String repositoryName, Revision revision) {
        if (revision.isRelative()) {
            return this.normalizeRevision(projectName, repositoryName, revision);
        }
        return CompletableFuture.completedFuture(revision);
    }
}

