/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.client;

import com.linecorp.centraldogma.client.Latest;
import com.linecorp.centraldogma.client.Watcher;
import com.linecorp.centraldogma.common.CentralDogmaException;
import com.linecorp.centraldogma.common.EntryNotFoundException;
import com.linecorp.centraldogma.common.RepositoryNotFoundException;
import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.common.ShuttingDownException;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.internal.shaded.guava.base.Preconditions;
import com.linecorp.centraldogma.internal.shaded.guava.math.LongMath;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractWatcher<T>
implements Watcher<T> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractWatcher.class);
    private final ScheduledExecutorService watchScheduler;
    private final String projectName;
    private final String repositoryName;
    private final String pathPattern;
    private final boolean errorOnEntryNotFound;
    private final long delayOnSuccessMillis;
    private final long initialDelayMillis;
    private final long maxDelayMillis;
    private final double multiplier;
    private final double jitterRate;
    private final List<Map.Entry<BiConsumer<? super Revision, ? super T>, Executor>> updateListeners = new CopyOnWriteArrayList<Map.Entry<BiConsumer<? super Revision, ? super T>, Executor>>();
    private final AtomicReference<State> state = new AtomicReference<State>(State.INIT);
    private final CompletableFuture<Latest<T>> initialValueFuture = new CompletableFuture();
    @Nullable
    private volatile Latest<T> latest;
    @Nullable
    private volatile ScheduledFuture<?> currentScheduleFuture;
    @Nullable
    private volatile CompletableFuture<?> currentWatchFuture;

    AbstractWatcher(ScheduledExecutorService watchScheduler, String projectName, String repositoryName, String pathPattern, boolean errorOnEntryNotFound, long delayOnSuccessMillis, long initialDelayMillis, long maxDelayMillis, double multiplier, double jitterRate) {
        this.watchScheduler = watchScheduler;
        this.projectName = projectName;
        this.repositoryName = repositoryName;
        this.pathPattern = pathPattern;
        this.errorOnEntryNotFound = errorOnEntryNotFound;
        this.delayOnSuccessMillis = delayOnSuccessMillis;
        this.initialDelayMillis = initialDelayMillis;
        this.maxDelayMillis = maxDelayMillis;
        this.multiplier = multiplier;
        this.jitterRate = jitterRate;
    }

    @Override
    public ScheduledExecutorService watchScheduler() {
        return this.watchScheduler;
    }

    @Override
    public CompletableFuture<Latest<T>> initialValueFuture() {
        return this.initialValueFuture;
    }

    @Override
    public Latest<T> latest() {
        Latest<T> latest = this.latest;
        if (latest == null) {
            throw new IllegalStateException("value not available yet");
        }
        return latest;
    }

    void start() {
        if (this.state.compareAndSet(State.INIT, State.STARTED)) {
            this.scheduleWatch(0);
        }
    }

    @Override
    public void close() {
        CompletableFuture<?> currentWatchFuture;
        ScheduledFuture<?> currentScheduleFuture;
        this.state.set(State.STOPPED);
        if (!this.initialValueFuture.isDone()) {
            this.initialValueFuture.cancel(false);
        }
        if ((currentScheduleFuture = this.currentScheduleFuture) != null && !currentScheduleFuture.isDone()) {
            currentScheduleFuture.cancel(false);
        }
        if ((currentWatchFuture = this.currentWatchFuture) != null && !currentWatchFuture.isDone()) {
            currentWatchFuture.cancel(false);
        }
    }

    private boolean isStopped() {
        return this.state.get() == State.STOPPED;
    }

    @Override
    public void watch(BiConsumer<? super Revision, ? super T> listener) {
        this.watch(listener, (Executor)this.watchScheduler);
    }

    @Override
    public void watch(BiConsumer<? super Revision, ? super T> listener, Executor executor) {
        Objects.requireNonNull(listener, "listener");
        Preconditions.checkState((!this.isStopped() ? 1 : 0) != 0, (Object)"watcher closed");
        this.updateListeners.add(new AbstractMap.SimpleImmutableEntry<BiConsumer<? super Revision, ? super T>, Executor>(listener, executor));
        Latest latest = this.latest;
        if (latest != null) {
            executor.execute(() -> listener.accept((Revision)latest.revision(), (Object)latest.value()));
        }
    }

    private void scheduleWatch(int numAttemptsSoFar) {
        if (this.isStopped()) {
            return;
        }
        long delay = numAttemptsSoFar == 0 ? (this.latest != null ? this.delayOnSuccessMillis : 0L) : this.nextDelayMillis(numAttemptsSoFar);
        this.currentScheduleFuture = this.watchScheduler.schedule(() -> {
            this.currentScheduleFuture = null;
            this.doWatch(numAttemptsSoFar);
        }, delay, TimeUnit.MILLISECONDS);
    }

    private long nextDelayMillis(int numAttemptsSoFar) {
        long nextDelayMillis = numAttemptsSoFar == 1 ? this.initialDelayMillis : Math.min(AbstractWatcher.saturatedMultiply(this.initialDelayMillis, Math.pow(this.multiplier, numAttemptsSoFar - 1)), this.maxDelayMillis);
        long minJitter = (long)((double)nextDelayMillis * (1.0 - this.jitterRate));
        long maxJitter = (long)((double)nextDelayMillis * (1.0 + this.jitterRate));
        long bound = maxJitter - minJitter + 1L;
        long millis = AbstractWatcher.random(bound);
        return Math.max(0L, LongMath.saturatedAdd((long)minJitter, (long)millis));
    }

    private static long saturatedMultiply(long left, double right) {
        double result = (double)left * right;
        return result >= 9.223372036854776E18 ? Long.MAX_VALUE : (long)result;
    }

    private static long random(long bound) {
        assert (bound > 0L);
        long mask = bound - 1L;
        ThreadLocalRandom random = ThreadLocalRandom.current();
        long result = ((Random)random).nextLong();
        if ((bound & mask) == 0L) {
            result &= mask;
        } else {
            long u = result >>> 1;
            while (u + mask - (result = u % bound) < 0L) {
                u = ((Random)random).nextLong() >>> 1;
            }
        }
        return result;
    }

    private void doWatch(int numAttemptsSoFar) {
        if (this.isStopped()) {
            return;
        }
        Latest<T> latest = this.latest;
        Revision lastKnownRevision = latest != null ? latest.revision() : Revision.INIT;
        CompletableFuture<Latest<T>> f = this.doWatch(lastKnownRevision);
        this.currentWatchFuture = f;
        ((CompletableFuture)f.thenAccept(newLatest -> {
            this.currentWatchFuture = null;
            if (newLatest != null) {
                this.latest = newLatest;
                logger.debug("watcher noticed updated file {}/{}{}: rev={}", new Object[]{this.projectName, this.repositoryName, this.pathPattern, newLatest.revision()});
                this.notifyListeners((Latest<T>)newLatest);
                if (!this.initialValueFuture.isDone()) {
                    this.initialValueFuture.complete((Latest<Latest>)newLatest);
                }
            }
            this.scheduleWatch(0);
        })).exceptionally(thrown -> {
            this.currentWatchFuture = null;
            try {
                Throwable cause = thrown instanceof CompletionException ? thrown.getCause() : thrown;
                boolean logged = false;
                if (cause instanceof CentralDogmaException) {
                    if (cause instanceof EntryNotFoundException) {
                        if (!this.initialValueFuture.isDone() && this.errorOnEntryNotFound) {
                            this.initialValueFuture.completeExceptionally((Throwable)thrown);
                            this.close();
                            return null;
                        }
                        logger.info("{}/{}{} does not exist yet; trying again", new Object[]{this.projectName, this.repositoryName, this.pathPattern});
                        logged = true;
                    } else if (cause instanceof RepositoryNotFoundException) {
                        logger.info("{}/{} does not exist yet; trying again", (Object)this.projectName, (Object)this.repositoryName);
                        logged = true;
                    } else if (cause instanceof ShuttingDownException) {
                        logger.info("Central Dogma is shutting down; trying again");
                        logged = true;
                    }
                }
                if (cause instanceof CancellationException) {
                    return null;
                }
                if (!logged) {
                    logger.warn("Failed to watch a file ({}/{}{}) at Central Dogma; trying again", new Object[]{this.projectName, this.repositoryName, this.pathPattern, cause});
                }
                this.scheduleWatch(numAttemptsSoFar + 1);
            }
            catch (Throwable t) {
                logger.error("Unexpected exception while watching a file at Central Dogma:", t);
            }
            return null;
        });
    }

    abstract CompletableFuture<Latest<T>> doWatch(Revision var1);

    private void notifyListeners(Latest<T> latest) {
        if (this.isStopped()) {
            return;
        }
        for (Map.Entry<BiConsumer<Revision, T>, Executor> entry : this.updateListeners) {
            BiConsumer<? super Revision, ? super T> listener = entry.getKey();
            Executor executor = entry.getValue();
            executor.execute(() -> {
                try {
                    listener.accept((Revision)latest.revision(), (T)latest.value());
                }
                catch (Exception e) {
                    logger.warn("Exception thrown for watcher ({}/{}{}): rev={}", new Object[]{this.projectName, this.repositoryName, this.pathPattern, latest.revision(), e});
                }
            });
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("watchScheduler", (Object)this.watchScheduler).add("projectName", (Object)this.projectName).add("repositoryName", (Object)this.repositoryName).add("pathPattern", (Object)this.pathPattern).add("errorOnEntryNotFound", this.errorOnEntryNotFound).add("delayOnSuccessMillis", this.delayOnSuccessMillis).add("initialDelayMillis", this.initialDelayMillis).add("maxDelayMillis", this.maxDelayMillis).add("multiplier", this.multiplier).add("jitterRate", this.jitterRate).add("latest", this.latest).toString();
    }

    private static enum State {
        INIT,
        STARTED,
        STOPPED;

    }
}

