/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.client;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.linecorp.centraldogma.internal.Jackson;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.internal.shaded.guava.base.Preconditions;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableSet;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

final class ClientProfile {
    private final String name;
    private final int priority;
    private final Set<Entry> hosts;

    @JsonCreator
    ClientProfile(@JsonProperty(value="name", required=true) String name, @JsonProperty(value="priority") @Nullable Integer priority, @JsonProperty(value="hosts") @JsonDeserialize(contentAs=Entry.class) @Nullable Set<Entry> hosts) {
        this.name = Objects.requireNonNull(name, "name");
        Preconditions.checkArgument((!name.isEmpty() ? 1 : 0) != 0, (Object)"name is empty.");
        this.priority = (Integer)MoreObjects.firstNonNull((Object)priority, (Object)0);
        this.hosts = ImmutableSet.copyOf((Collection)((Collection)MoreObjects.firstNonNull(hosts, (Object)ImmutableSet.of())));
    }

    @JsonProperty
    String name() {
        return this.name;
    }

    @JsonProperty
    int priority() {
        return this.priority;
    }

    @JsonProperty
    Set<Entry> hosts() {
        return this.hosts;
    }

    public String toString() {
        try {
            return Jackson.writeValueAsPrettyString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new Error(e);
        }
    }

    static final class Entry {
        private final String host;
        private final String protocol;
        private final int port;

        @JsonCreator
        Entry(@JsonProperty(value="host", required=true) String host, @JsonProperty(value="protocol", required=true) String protocol, @JsonProperty(value="port", required=true) Integer port) {
            this.host = Objects.requireNonNull(host, "host");
            Preconditions.checkArgument((!host.isEmpty() ? 1 : 0) != 0, (Object)"hostname is empty.");
            this.protocol = Objects.requireNonNull(protocol, "protocol");
            Preconditions.checkArgument((!protocol.isEmpty() ? 1 : 0) != 0, (Object)"protocol is empty.");
            this.port = Objects.requireNonNull(port, "port");
            Preconditions.checkArgument((port > 0 && port < 65536 ? 1 : 0) != 0, (String)"port: %s (expected: 1..65535)", (Object)port);
        }

        @JsonProperty
        String host() {
            return this.host;
        }

        @JsonProperty
        String protocol() {
            return this.protocol;
        }

        @JsonProperty
        int port() {
            return this.port;
        }

        public String toString() {
            try {
                return Jackson.writeValueAsPrettyString((Object)this);
            }
            catch (JsonProcessingException e) {
                throw new Error(e);
            }
        }
    }
}

