/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.client;

import com.linecorp.centraldogma.client.AbstractWatcher;
import com.linecorp.centraldogma.client.CentralDogma;
import com.linecorp.centraldogma.client.Latest;
import com.linecorp.centraldogma.common.Entry;
import com.linecorp.centraldogma.common.Query;
import com.linecorp.centraldogma.common.Revision;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import javax.annotation.Nullable;

final class FileWatcher<T>
extends AbstractWatcher<T> {
    private final CentralDogma centralDogma;
    private final String projectName;
    private final String repositoryName;
    private final Query<T> query;
    private final long timeoutMillis;
    private final boolean errorOnEntryNotFound;
    @Nullable
    private final Function<Object, ? extends T> mapper;
    @Nullable
    private final Executor mapperExecutor;

    FileWatcher(CentralDogma centralDogma, ScheduledExecutorService watchScheduler, String projectName, String repositoryName, Query<T> query, long timeoutMillis, boolean errorOnEntryNotFound, @Nullable Function<Object, ? extends T> mapper, Executor mapperExecutor, long delayOnSuccessMillis, long initialDelayMillis, long maxDelayMillis, double multiplier, double jitterRate) {
        super(watchScheduler, projectName, repositoryName, query.path(), errorOnEntryNotFound, delayOnSuccessMillis, initialDelayMillis, maxDelayMillis, multiplier, jitterRate);
        this.centralDogma = centralDogma;
        this.projectName = projectName;
        this.repositoryName = repositoryName;
        this.query = query;
        this.timeoutMillis = timeoutMillis;
        this.errorOnEntryNotFound = errorOnEntryNotFound;
        this.mapper = mapper;
        this.mapperExecutor = mapperExecutor;
    }

    @Override
    CompletableFuture<Latest<T>> doWatch(Revision lastKnownRevision) {
        CompletableFuture<Entry<T>> future = this.centralDogma.watchFile(this.projectName, this.repositoryName, lastKnownRevision, this.query, this.timeoutMillis, this.errorOnEntryNotFound);
        if (this.mapper == null) {
            return future.thenApply(entry -> {
                if (entry == null) {
                    return null;
                }
                return new Latest<Object>(entry.revision(), entry.content());
            });
        }
        return future.thenApplyAsync(entry -> {
            if (entry == null) {
                return null;
            }
            return new Latest<T>(entry.revision(), this.mapper.apply(entry.content()));
        }, this.mapperExecutor);
    }
}

