/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.client;

import com.linecorp.centraldogma.client.AbstractWatcher;
import com.linecorp.centraldogma.client.CentralDogma;
import com.linecorp.centraldogma.client.Latest;
import com.linecorp.centraldogma.common.PathPattern;
import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.internal.Util;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import javax.annotation.Nullable;

final class FilesWatcher<T>
extends AbstractWatcher<T> {
    private final CentralDogma centralDogma;
    private final String projectName;
    private final String repositoryName;
    private final PathPattern pathPattern;
    private final long timeoutMillis;
    private final boolean errorOnEntryNotFound;
    @Nullable
    private final Function<Revision, ? extends T> mapper;
    @Nullable
    private final Executor mapperExecutor;

    FilesWatcher(CentralDogma centralDogma, ScheduledExecutorService watchScheduler, String projectName, String repositoryName, PathPattern pathPattern, long timeoutMillis, boolean errorOnEntryNotFound, @Nullable Function<Object, ? extends T> mapper, Executor mapperExecutor, long delayOnSuccessMillis, long initialDelayMillis, long maxDelayMillis, double multiplier, double jitterRate) {
        super(watchScheduler, projectName, repositoryName, pathPattern.patternString(), errorOnEntryNotFound, delayOnSuccessMillis, initialDelayMillis, maxDelayMillis, multiplier, jitterRate);
        this.centralDogma = centralDogma;
        this.projectName = projectName;
        this.repositoryName = repositoryName;
        this.pathPattern = pathPattern;
        this.timeoutMillis = timeoutMillis;
        this.errorOnEntryNotFound = errorOnEntryNotFound;
        this.mapper = mapper != null ? (Function)Util.unsafeCast(mapper) : null;
        this.mapperExecutor = mapperExecutor;
    }

    @Override
    CompletableFuture<Latest<T>> doWatch(Revision lastKnownRevision) {
        CompletableFuture<Revision> future = this.centralDogma.watchRepository(this.projectName, this.repositoryName, lastKnownRevision, this.pathPattern, this.timeoutMillis, this.errorOnEntryNotFound);
        if (this.mapper == null) {
            return future.thenApply(revision -> {
                if (revision == null) {
                    return null;
                }
                return new Latest<Revision>((Revision)revision, (Revision)revision);
            });
        }
        return future.thenApplyAsync(revision -> {
            if (revision == null) {
                return null;
            }
            return new Latest<T>((Revision)revision, this.mapper.apply((Revision)revision));
        }, this.mapperExecutor);
    }
}

