/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.client;

import com.linecorp.centraldogma.client.Latest;
import com.linecorp.centraldogma.client.Watcher;
import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.internal.shaded.guava.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class MappingWatcher<T, U>
implements Watcher<U> {
    private static final Logger logger = LoggerFactory.getLogger(MappingWatcher.class);
    private final Watcher<T> parent;
    private final Function<? super T, ? extends U> mapper;
    private final Executor mapperExecutor;
    private final boolean closeParentWhenClosing;
    private final CompletableFuture<Latest<U>> initialValueFuture = new CompletableFuture();
    private final List<Map.Entry<BiConsumer<? super Revision, ? super U>, Executor>> updateListeners = new CopyOnWriteArrayList<Map.Entry<BiConsumer<? super Revision, ? super U>, Executor>>();
    @Nullable
    private volatile Latest<U> mappedLatest;
    private volatile boolean closed;

    static <T, U> MappingWatcher<T, U> of(Watcher<T> parent, Function<? super T, ? extends U> mapper, Executor executor, boolean closeParentWhenClosing) {
        Objects.requireNonNull(parent, "parent");
        Objects.requireNonNull(mapper, "mapper");
        Objects.requireNonNull(executor, "executor");
        return new MappingWatcher<T, U>(parent, mapper, executor, closeParentWhenClosing);
    }

    MappingWatcher(Watcher<T> parent, Function<? super T, ? extends U> mapper, Executor mapperExecutor, boolean closeParentWhenClosing) {
        this.parent = parent;
        this.mapper = mapper;
        this.mapperExecutor = mapperExecutor;
        this.closeParentWhenClosing = closeParentWhenClosing;
        parent.initialValueFuture().exceptionally(cause -> {
            this.initialValueFuture.completeExceptionally((Throwable)cause);
            return null;
        });
        parent.watch((? super Revision revision, ? super T value) -> {
            Object mappedValue;
            if (this.closed) {
                return;
            }
            try {
                mappedValue = mapper.apply(value);
            }
            catch (Exception e) {
                logger.warn("Unexpected exception is raised from mapper.apply(). mapper: {}", (Object)mapper, (Object)e);
                if (!this.initialValueFuture.isDone()) {
                    this.initialValueFuture.completeExceptionally(e);
                }
                this.close();
                return;
            }
            Latest<U> oldLatest = this.mappedLatest;
            if (oldLatest != null && Objects.equals(oldLatest.value(), mappedValue)) {
                return;
            }
            Latest newLatest = new Latest((Revision)revision, mappedValue);
            this.mappedLatest = newLatest;
            this.notifyListeners(newLatest);
            if (!this.initialValueFuture.isDone()) {
                this.initialValueFuture.complete(newLatest);
            }
        }, mapperExecutor);
    }

    private void notifyListeners(Latest<U> latest) {
        if (this.closed) {
            return;
        }
        for (Map.Entry<BiConsumer<Revision, U>, Executor> entry : this.updateListeners) {
            BiConsumer<? super Revision, ? super U> listener = entry.getKey();
            Executor executor = entry.getValue();
            if (this.mapperExecutor == executor) {
                this.notifyListener(latest, listener);
                continue;
            }
            executor.execute(() -> this.notifyListener(latest, listener));
        }
    }

    private void notifyListener(Latest<U> latest, BiConsumer<? super Revision, ? super U> listener) {
        try {
            listener.accept((Revision)latest.revision(), latest.value());
        }
        catch (Exception e) {
            logger.warn("Unexpected exception is raised from {}: rev={}", new Object[]{listener, latest.revision(), e});
        }
    }

    @Override
    public ScheduledExecutorService watchScheduler() {
        return this.parent.watchScheduler();
    }

    @Override
    public CompletableFuture<Latest<U>> initialValueFuture() {
        return this.initialValueFuture;
    }

    @Override
    public Latest<U> latest() {
        Latest<U> mappedLatest = this.mappedLatest;
        if (mappedLatest == null) {
            throw new IllegalStateException("value not available yet");
        }
        return mappedLatest;
    }

    @Override
    public void close() {
        this.closed = true;
        if (!this.initialValueFuture.isDone()) {
            this.initialValueFuture.cancel(false);
        }
        if (this.closeParentWhenClosing) {
            this.parent.close();
        }
    }

    @Override
    public void watch(BiConsumer<? super Revision, ? super U> listener) {
        this.watch(listener, (Executor)this.parent.watchScheduler());
    }

    @Override
    public void watch(BiConsumer<? super Revision, ? super U> listener, Executor executor) {
        Objects.requireNonNull(listener, "listener");
        Objects.requireNonNull(executor, "executor");
        this.updateListeners.add(Maps.immutableEntry(listener, (Object)executor));
        Latest mappedLatest = this.mappedLatest;
        if (mappedLatest != null) {
            executor.execute(() -> listener.accept((Revision)mappedLatest.revision(), (Object)mappedLatest.value()));
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("parent", this.parent).add("mapper", this.mapper).add("closed", this.closed).toString();
    }
}

