/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.client;

import com.linecorp.centraldogma.client.CentralDogmaRepository;
import com.linecorp.centraldogma.common.MergeQuery;
import com.linecorp.centraldogma.common.MergedEntry;
import com.linecorp.centraldogma.common.Revision;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public final class MergeRequest<T> {
    private final CentralDogmaRepository centralDogmaRepo;
    private final MergeQuery<T> mergeQuery;

    MergeRequest(CentralDogmaRepository centralDogmaRepo, MergeQuery<T> mergeQuery) {
        this.centralDogmaRepo = centralDogmaRepo;
        this.mergeQuery = mergeQuery;
    }

    public CompletableFuture<MergedEntry<T>> get() {
        return this.get(Revision.HEAD);
    }

    public CompletableFuture<MergedEntry<T>> get(Revision revision) {
        Objects.requireNonNull(revision, "revision");
        return this.centralDogmaRepo.centralDogma().mergeFiles(this.centralDogmaRepo.projectName(), this.centralDogmaRepo.repositoryName(), revision, this.mergeQuery);
    }
}

