/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.client;

import com.linecorp.centraldogma.client.CentralDogmaRepository;
import com.linecorp.centraldogma.common.Change;
import com.linecorp.centraldogma.common.Revision;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public final class PreviewDiffRequest {
    private final CentralDogmaRepository centralDogmaRepo;
    private final Iterable<? extends Change<?>> changes;

    PreviewDiffRequest(CentralDogmaRepository centralDogmaRepo, Iterable<? extends Change<?>> changes) {
        this.centralDogmaRepo = centralDogmaRepo;
        this.changes = changes;
    }

    public CompletableFuture<List<Change<?>>> get() {
        return this.get(Revision.HEAD);
    }

    public CompletableFuture<List<Change<?>>> get(Revision baseRevision) {
        Objects.requireNonNull(baseRevision, "baseRevision");
        return this.centralDogmaRepo.centralDogma().getPreviewDiffs(this.centralDogmaRepo.projectName(), this.centralDogmaRepo.repositoryName(), baseRevision, this.changes);
    }
}

