/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.client;

import com.linecorp.centraldogma.client.CentralDogmaRepository;
import com.linecorp.centraldogma.client.WatchOptions;
import com.linecorp.centraldogma.common.Entry;
import com.linecorp.centraldogma.common.Query;
import com.linecorp.centraldogma.common.Revision;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public final class WatchRequest<T>
extends WatchOptions {
    private final CentralDogmaRepository centralDogmaRepo;
    private final Query<T> query;

    WatchRequest(CentralDogmaRepository centralDogmaRepo, Query<T> query) {
        this.centralDogmaRepo = centralDogmaRepo;
        this.query = query;
    }

    @Override
    public WatchRequest<T> timeout(Duration timeout) {
        return (WatchRequest)super.timeout(timeout);
    }

    @Override
    public WatchRequest<T> timeoutMillis(long timeoutMillis) {
        return (WatchRequest)super.timeoutMillis(timeoutMillis);
    }

    @Override
    public WatchRequest<T> errorOnEntryNotFound(boolean errorOnEntryNotFound) {
        return (WatchRequest)super.errorOnEntryNotFound(errorOnEntryNotFound);
    }

    public CompletableFuture<Entry<T>> start() {
        return this.start(Revision.HEAD);
    }

    public CompletableFuture<Entry<T>> start(Revision lastKnownRevision) {
        Objects.requireNonNull(lastKnownRevision, "lastKnownRevision");
        return this.centralDogmaRepo.centralDogma().watchFile(this.centralDogmaRepo.projectName(), this.centralDogmaRepo.repositoryName(), lastKnownRevision, this.query, this.timeoutMillis(), this.errorOnEntryNotFound());
    }
}

