/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.linecorp.centraldogma.client.Latest;
import com.linecorp.centraldogma.client.MappingWatcher;
import com.linecorp.centraldogma.common.EntryNotFoundException;
import com.linecorp.centraldogma.common.Revision;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;

public interface Watcher<T>
extends AutoCloseable {
    public static Watcher<JsonNode> atJsonPointer(Watcher<JsonNode> watcher, final String jsonPointer) {
        Objects.requireNonNull(watcher, "watcher");
        Objects.requireNonNull(jsonPointer, "jsonPointer");
        return watcher.newChild(new Function<JsonNode, JsonNode>(){

            @Override
            public JsonNode apply(JsonNode node) {
                if (node == null) {
                    return MissingNode.getInstance();
                }
                return node.at(jsonPointer);
            }

            public String toString() {
                return "JSON pointer " + jsonPointer;
            }
        });
    }

    public ScheduledExecutorService watchScheduler();

    public CompletableFuture<Latest<T>> initialValueFuture();

    default public Latest<T> awaitInitialValue() throws InterruptedException {
        try {
            return this.initialValueFuture().get();
        }
        catch (ExecutionException e) {
            throw new Error(e);
        }
    }

    default public Latest<T> awaitInitialValue(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        Objects.requireNonNull(unit, "unit");
        try {
            return this.initialValueFuture().get(timeout, unit);
        }
        catch (TimeoutException e) {
            long initialTimeoutMillis = TimeUnit.MILLISECONDS.convert(timeout, unit);
            throw new TimeoutException("Failed to get the initial value in " + initialTimeoutMillis + " ms. It's probably because the timeout value is too small or the target entry doesn't exist. Please consider using the 'errorOnEntryNotFound' option to get an " + EntryNotFoundException.class.getSimpleName() + " for a missing entry.");
        }
        catch (ExecutionException e) {
            throw new Error(e);
        }
    }

    @Nullable
    default public T awaitInitialValue(long timeout, TimeUnit unit, @Nullable T defaultValue) throws InterruptedException {
        try {
            return this.awaitInitialValue(timeout, unit).value();
        }
        catch (TimeoutException e) {
            return defaultValue;
        }
    }

    public Latest<T> latest();

    @Nullable
    default public T latestValue() {
        return this.latest().value();
    }

    @Nullable
    default public T latestValue(@Nullable T defaultValue) {
        CompletableFuture<Latest<T>> initialValueFuture = this.initialValueFuture();
        if (initialValueFuture.isDone() && !initialValueFuture.isCompletedExceptionally()) {
            return this.latest().value();
        }
        return defaultValue;
    }

    @Override
    public void close();

    public void watch(BiConsumer<? super Revision, ? super T> var1);

    public void watch(BiConsumer<? super Revision, ? super T> var1, Executor var2);

    default public void watch(Consumer<? super T> listener) {
        Objects.requireNonNull(listener, "listener");
        this.watch((? super Revision revision, ? super T value) -> listener.accept(value));
    }

    default public void watch(Consumer<? super T> listener, Executor executor) {
        Objects.requireNonNull(listener, "listener");
        Objects.requireNonNull(executor, "executor");
        this.watch((? super Revision revision, ? super T value) -> listener.accept(value), executor);
    }

    default public <U> Watcher<U> newChild(Function<? super T, ? extends U> mapper) {
        return this.newChild(mapper, this.watchScheduler());
    }

    default public <U> Watcher<U> newChild(Function<? super T, ? extends U> mapper, Executor executor) {
        Objects.requireNonNull(mapper, "mapper");
        Objects.requireNonNull(executor, "executor");
        return MappingWatcher.of(this, mapper, executor, false);
    }
}

