/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.client;

import com.linecorp.centraldogma.client.AbstractWatcher;
import com.linecorp.centraldogma.client.CentralDogmaRepository;
import com.linecorp.centraldogma.client.FileWatcher;
import com.linecorp.centraldogma.client.FilesWatcher;
import com.linecorp.centraldogma.client.WatchOptions;
import com.linecorp.centraldogma.client.Watcher;
import com.linecorp.centraldogma.common.PathPattern;
import com.linecorp.centraldogma.common.Query;
import com.linecorp.centraldogma.internal.shaded.guava.base.Preconditions;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class WatcherRequest<T>
extends WatchOptions {
    private static final long DEFAULT_DELAY_ON_SUCCESS_MILLIS = TimeUnit.SECONDS.toMillis(1L);
    private static final long DEFAULT_MAX_DELAY_MILLIS = TimeUnit.MINUTES.toMillis(1L);
    private static final double DEFAULT_MULTIPLIER = 2.0;
    private static final double DEFAULT_JITTER_RATE = 0.2;
    private final CentralDogmaRepository centralDogmaRepo;
    @Nullable
    private final Query<T> query;
    @Nullable
    private final PathPattern pathPattern;
    private final ScheduledExecutorService blockingTaskExecutor;
    @Nullable
    private Function<Object, ? extends T> mapper;
    private Executor executor;
    private long delayOnSuccessMillis = DEFAULT_DELAY_ON_SUCCESS_MILLIS;
    private long initialDelayMillis = DEFAULT_DELAY_ON_SUCCESS_MILLIS * 2L;
    private long maxDelayMillis = DEFAULT_MAX_DELAY_MILLIS;
    private double multiplier = 2.0;
    private double jitterRate = 0.2;

    WatcherRequest(CentralDogmaRepository centralDogmaRepo, Query<T> query, ScheduledExecutorService blockingTaskExecutor) {
        this(centralDogmaRepo, query, null, blockingTaskExecutor);
    }

    WatcherRequest(CentralDogmaRepository centralDogmaRepo, PathPattern pathPattern, ScheduledExecutorService blockingTaskExecutor) {
        this(centralDogmaRepo, null, pathPattern, blockingTaskExecutor);
    }

    private WatcherRequest(CentralDogmaRepository centralDogmaRepo, @Nullable Query<T> query, @Nullable PathPattern pathPattern, ScheduledExecutorService blockingTaskExecutor) {
        this.centralDogmaRepo = centralDogmaRepo;
        this.query = query;
        this.pathPattern = pathPattern;
        this.blockingTaskExecutor = blockingTaskExecutor;
        this.executor = blockingTaskExecutor;
    }

    public <U> WatcherRequest<U> map(Function<? super T, ? extends U> mapper) {
        this.mapper = this.mapper == null ? mapper : this.mapper.andThen(mapper);
        return this;
    }

    public WatcherRequest<T> mapperExecutor(Executor executor) {
        this.executor = executor;
        return this;
    }

    public WatcherRequest<T> delayOnSuccess(Duration delayOnSuccess) {
        Objects.requireNonNull(delayOnSuccess, "delayOnSuccess");
        Preconditions.checkArgument((!delayOnSuccess.isNegative() ? 1 : 0) != 0, (String)"delayOnSuccess: %s (expected: >= 0)", (Object)delayOnSuccess);
        return this.delayOnSuccessMillis(delayOnSuccess.toMillis());
    }

    public WatcherRequest<T> delayOnSuccessMillis(long delayOnSuccessMillis) {
        this.delayOnSuccessMillis = delayOnSuccessMillis;
        Preconditions.checkArgument((delayOnSuccessMillis >= 0L ? 1 : 0) != 0, (String)"delayOnSuccessMillis: %s (expected: >= 0)", (long)delayOnSuccessMillis);
        return this;
    }

    public WatcherRequest<T> backoffOnFailure(long initialDelayMillis, long maxDelayMillis, double multiplier) {
        Preconditions.checkArgument((initialDelayMillis >= 0L ? 1 : 0) != 0, (String)"initialDelayMillis: %s (expected: >= 0)", (long)initialDelayMillis);
        Preconditions.checkArgument((initialDelayMillis <= maxDelayMillis ? 1 : 0) != 0, (String)"maxDelayMillis: %s (expected: >= %s)", (long)maxDelayMillis, (long)initialDelayMillis);
        Preconditions.checkArgument((multiplier > 1.0 ? 1 : 0) != 0, (String)"multiplier: %s (expected: > 1.0)", (Object)multiplier);
        this.initialDelayMillis = initialDelayMillis;
        this.maxDelayMillis = maxDelayMillis;
        this.multiplier = multiplier;
        return this;
    }

    public WatcherRequest<T> jitterRate(double jitterRate) {
        Preconditions.checkArgument((0.0 <= jitterRate && jitterRate <= 1.0 ? 1 : 0) != 0, (String)"jitterRate: %s (expected: >= 0.0 and <= 1.0)", (Object)jitterRate);
        this.jitterRate = jitterRate;
        return this;
    }

    @Override
    public WatcherRequest<T> timeout(Duration timeout) {
        return (WatcherRequest)super.timeout(timeout);
    }

    @Override
    public WatcherRequest<T> timeoutMillis(long timeoutMillis) {
        return (WatcherRequest)super.timeoutMillis(timeoutMillis);
    }

    @Override
    public WatcherRequest<T> errorOnEntryNotFound(boolean errorOnEntryNotFound) {
        return (WatcherRequest)super.errorOnEntryNotFound(errorOnEntryNotFound);
    }

    public Watcher<T> start() {
        AbstractWatcher watcher;
        String proName = this.centralDogmaRepo.projectName();
        String repoName = this.centralDogmaRepo.repositoryName();
        if (this.query != null) {
            watcher = new FileWatcher<T>(this.centralDogmaRepo.centralDogma(), this.blockingTaskExecutor, proName, repoName, this.query, this.timeoutMillis(), this.errorOnEntryNotFound(), this.mapper, this.executor, this.delayOnSuccessMillis, this.initialDelayMillis, this.maxDelayMillis, this.multiplier, this.jitterRate);
        } else {
            assert (this.pathPattern != null);
            watcher = new FilesWatcher<T>(this.centralDogmaRepo.centralDogma(), this.blockingTaskExecutor, proName, repoName, this.pathPattern, this.timeoutMillis(), this.errorOnEntryNotFound(), this.mapper, this.executor, this.delayOnSuccessMillis, this.initialDelayMillis, this.maxDelayMillis, this.multiplier, this.jitterRate);
        }
        watcher.start();
        return watcher;
    }
}

