/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.client.updater;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.linecorp.centraldogma.client.CentralDogma;
import com.linecorp.centraldogma.client.Latest;
import com.linecorp.centraldogma.client.Watcher;
import com.linecorp.centraldogma.client.updater.CentralDogmaBean;
import com.linecorp.centraldogma.client.updater.CentralDogmaBeanConfig;
import com.linecorp.centraldogma.client.updater.CentralDogmaBeanConfigBuilder;
import com.linecorp.centraldogma.client.updater.CentralDogmaBeanMethodHandler;
import com.linecorp.centraldogma.common.CentralDogmaException;
import com.linecorp.centraldogma.common.Query;
import com.linecorp.centraldogma.internal.shaded.guava.base.Preconditions;
import com.linecorp.centraldogma.internal.shaded.guava.base.Strings;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import javassist.util.proxy.ProxyFactory;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class CentralDogmaBeanFactory {
    private static final Logger logger = LoggerFactory.getLogger(CentralDogmaBeanFactory.class);
    private static final Class<?>[] EMPTY_TYPES = new Class[0];
    private static final Object[] EMPTY_ARGS = new Object[0];
    private final CentralDogma dogma;
    private final ObjectMapper objectMapper;

    @Inject
    public CentralDogmaBeanFactory(CentralDogma dogma, ObjectMapper objectMapper) {
        this.dogma = Objects.requireNonNull(dogma, "dogma");
        this.objectMapper = Objects.requireNonNull(objectMapper, "objectMapper");
    }

    public <T> T get(T defaultValue, Class<T> beanType) {
        return (T)this.get(defaultValue, beanType, x -> {}, CentralDogmaBeanConfig.EMPTY);
    }

    public <T> T get(T defaultValue, Class<T> beanType, Consumer<T> changeListener) {
        return this.get(defaultValue, beanType, changeListener, CentralDogmaBeanConfig.EMPTY);
    }

    public <T> T get(T defaultValue, Class<T> beanType, Consumer<T> changeListener, CentralDogmaBeanConfig overrides) {
        try {
            return this.get(defaultValue, beanType, changeListener, overrides, 0L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | TimeoutException e) {
            throw new RuntimeException("Error: unexpected exception caught", e);
        }
    }

    public <T> T get(T defaultValue, Class<T> beanType, Consumer<T> changeListener, long initialValueTimeout, TimeUnit initialValueTimeoutUnit) throws TimeoutException, InterruptedException {
        return this.get(defaultValue, beanType, changeListener, CentralDogmaBeanConfig.EMPTY, initialValueTimeout, initialValueTimeoutUnit);
    }

    public <T> T get(T defaultValue, Class<T> beanType, CentralDogmaBeanConfig overrides) {
        try {
            return this.get(defaultValue, beanType, overrides, 0L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | TimeoutException e) {
            throw new RuntimeException("Error: unexpected exception caught", e);
        }
    }

    public <T> T get(T defaultValue, Class<T> beanType, long initialValueTimeout, TimeUnit initialValueTimeoutUnit) throws TimeoutException, InterruptedException {
        return this.get(defaultValue, beanType, CentralDogmaBeanConfig.EMPTY, initialValueTimeout, initialValueTimeoutUnit);
    }

    public <T> T get(T defaultValue, Class<T> beanType, CentralDogmaBeanConfig overrides, long initialValueTimeout, TimeUnit initialValueTimeoutUnit) throws TimeoutException, InterruptedException {
        return (T)this.get(defaultValue, beanType, x -> {}, overrides, initialValueTimeout, initialValueTimeoutUnit);
    }

    public <T> T get(T defaultValue, Class<T> beanType, Consumer<T> changeListener, CentralDogmaBeanConfig overrides, long initialValueTimeout, TimeUnit initialValueTimeoutUnit) throws TimeoutException, InterruptedException {
        Objects.requireNonNull(defaultValue, "defaultValue");
        Objects.requireNonNull(beanType, "beanType");
        Objects.requireNonNull(overrides, "overrides");
        Objects.requireNonNull(initialValueTimeoutUnit, "initialValueTimeoutUnit");
        CentralDogmaBean centralDogmaBean = beanType.getAnnotation(CentralDogmaBean.class);
        if (centralDogmaBean == null) {
            throw new IllegalArgumentException("missing CentralDogmaBean annotation");
        }
        CentralDogmaBeanConfig settings = CentralDogmaBeanFactory.merge(CentralDogmaBeanFactory.convertToSettings(centralDogmaBean), overrides);
        Preconditions.checkState((!Strings.isNullOrEmpty((String)settings.project().get()) ? 1 : 0) != 0, (Object)"settings.projectName should non-null");
        Preconditions.checkState((!Strings.isNullOrEmpty((String)settings.repository().get()) ? 1 : 0) != 0, (Object)"settings.repositoryName should non-null");
        Preconditions.checkState((!Strings.isNullOrEmpty((String)settings.path().get()) ? 1 : 0) != 0, (Object)"settings.fileName should non-null");
        Watcher<Object> watcher = this.dogma.forRepo(settings.project().get(), settings.repository().get()).watcher(CentralDogmaBeanFactory.buildQuery(settings)).map(jsonNode -> {
            try {
                Object value = this.objectMapper.treeToValue((TreeNode)jsonNode, beanType);
                changeListener.accept(value);
                return value;
            }
            catch (JsonProcessingException e) {
                throw new IllegalStateException("Failed to convert a JSON node into: " + beanType.getName(), e);
            }
        }).start();
        if (initialValueTimeout > 0L) {
            Latest<Object> latest;
            long t0 = System.nanoTime();
            try {
                latest = watcher.awaitInitialValue(initialValueTimeout, initialValueTimeoutUnit);
            }
            catch (TimeoutException ex) {
                long initialTimeoutMillis = TimeUnit.MILLISECONDS.convert(initialValueTimeout, initialValueTimeoutUnit);
                if (!this.dogma.whenEndpointReady().isDone()) {
                    String message = "Failed to resolve the initial endpoints of the given Central Dogma client in " + initialTimeoutMillis + " ms. You may want to increase 'initialValueTimeout' or wait for the initial endpoints using 'CentralDogma.whenEndpointReady().get()' before initializing this " + CentralDogmaBeanFactory.class.getSimpleName() + '.';
                    throw new CentralDogmaException(message, (Throwable)ex);
                }
                throw ex;
            }
            long elapsedMillis = System.nanoTime() - t0;
            logger.debug("Initial value of {} obtained in {} ms: rev={}", new Object[]{settings, elapsedMillis, latest.revision()});
        }
        ProxyFactory factory = new ProxyFactory();
        factory.setSuperclass(beanType);
        factory.setFilter(method -> {
            if (method.getParameterCount() == 0) {
                return true;
            }
            return centralDogmaBean.bidirectional() && method.getParameterCount() == 1;
        });
        try {
            return (T)factory.create((Class[])EMPTY_TYPES, EMPTY_ARGS, new CentralDogmaBeanMethodHandler<Object>(watcher, defaultValue));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static CentralDogmaBeanConfig convertToSettings(CentralDogmaBean property) {
        return new CentralDogmaBeanConfigBuilder().project(property.project()).repository(property.repository()).path(property.path()).jsonPath(property.jsonPath()).build();
    }

    private static CentralDogmaBeanConfig merge(CentralDogmaBeanConfig defaultSettings, CentralDogmaBeanConfig overridden) {
        return new CentralDogmaBeanConfigBuilder(defaultSettings).merge(overridden).build();
    }

    private static Query<JsonNode> buildQuery(CentralDogmaBeanConfig config) {
        Preconditions.checkArgument((boolean)config.path().get().endsWith(".json"), (String)"path: %s (expected: ends with '.json')", (Object)config.path().get());
        return Query.ofJsonPath((String)config.path().get(), (String[])new String[]{config.jsonPath().orElse("$")});
    }
}

