/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.internal.client;

import com.linecorp.centraldogma.client.AbstractCentralDogma;
import com.linecorp.centraldogma.client.CentralDogma;
import com.linecorp.centraldogma.client.CentralDogmaRepository;
import com.linecorp.centraldogma.client.RepositoryInfo;
import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.common.Change;
import com.linecorp.centraldogma.common.Commit;
import com.linecorp.centraldogma.common.Entry;
import com.linecorp.centraldogma.common.EntryType;
import com.linecorp.centraldogma.common.Markup;
import com.linecorp.centraldogma.common.MergeQuery;
import com.linecorp.centraldogma.common.MergedEntry;
import com.linecorp.centraldogma.common.PathPattern;
import com.linecorp.centraldogma.common.PushResult;
import com.linecorp.centraldogma.common.Query;
import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.common.RevisionNotFoundException;
import com.linecorp.centraldogma.internal.shaded.futures.CompletableFutures;
import com.linecorp.centraldogma.internal.shaded.guava.annotations.VisibleForTesting;
import com.linecorp.centraldogma.internal.shaded.guava.base.Preconditions;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReplicationLagTolerantCentralDogma
extends AbstractCentralDogma {
    private static final Logger logger = LoggerFactory.getLogger(ReplicationLagTolerantCentralDogma.class);
    private final CentralDogma delegate;
    private final int maxRetries;
    private final long retryIntervalMillis;
    private final Supplier<?> currentReplicaHintSupplier;
    private final Map<RepoId, Revision> latestKnownRevisions = new LinkedHashMap<RepoId, Revision>(){
        private static final long serialVersionUID = 3587793379404809027L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<RepoId, Revision> eldest) {
            return this.size() > 8192;
        }
    };

    public ReplicationLagTolerantCentralDogma(ScheduledExecutorService blockingTaskExecutor, CentralDogma delegate, int maxRetries, long retryIntervalMillis, Supplier<?> currentReplicaHintSupplier) {
        super(blockingTaskExecutor);
        Objects.requireNonNull(delegate, "delegate");
        Preconditions.checkArgument((maxRetries > 0 ? 1 : 0) != 0, (String)"maxRetries: %s (expected: > 0)", (int)maxRetries);
        Preconditions.checkArgument((retryIntervalMillis >= 0L ? 1 : 0) != 0, (String)"retryIntervalMillis: %s (expected: >= 0)", (long)retryIntervalMillis);
        Objects.requireNonNull(currentReplicaHintSupplier, "currentReplicaHintSupplier");
        this.delegate = delegate;
        this.maxRetries = maxRetries;
        this.retryIntervalMillis = retryIntervalMillis;
        this.currentReplicaHintSupplier = currentReplicaHintSupplier;
    }

    @Override
    public CompletableFuture<Void> createProject(String projectName) {
        return this.delegate.createProject(projectName);
    }

    @Override
    public CompletableFuture<Void> removeProject(String projectName) {
        return this.delegate.removeProject(projectName);
    }

    @Override
    public CompletableFuture<Void> purgeProject(String projectName) {
        return this.delegate.purgeProject(projectName);
    }

    @Override
    public CompletableFuture<Void> unremoveProject(String projectName) {
        return this.delegate.unremoveProject(projectName);
    }

    @Override
    public CompletableFuture<Set<String>> listProjects() {
        return this.delegate.listProjects();
    }

    @Override
    public CompletableFuture<Set<String>> listRemovedProjects() {
        return this.delegate.listRemovedProjects();
    }

    @Override
    public CompletableFuture<CentralDogmaRepository> createRepository(String projectName, String repositoryName) {
        return this.delegate.createRepository(projectName, repositoryName);
    }

    @Override
    public CompletableFuture<Void> removeRepository(String projectName, String repositoryName) {
        return this.delegate.removeRepository(projectName, repositoryName);
    }

    @Override
    public CompletableFuture<Void> purgeRepository(String projectName, String repositoryName) {
        return this.delegate.purgeRepository(projectName, repositoryName);
    }

    @Override
    public CompletableFuture<CentralDogmaRepository> unremoveRepository(String projectName, String repositoryName) {
        return this.delegate.unremoveRepository(projectName, repositoryName);
    }

    @Override
    public CompletableFuture<Map<String, RepositoryInfo>> listRepositories(final String projectName) {
        return this.executeWithRetries(new Supplier<CompletableFuture<Map<String, RepositoryInfo>>>(){

            @Override
            public CompletableFuture<Map<String, RepositoryInfo>> get() {
                return ReplicationLagTolerantCentralDogma.this.delegate.listRepositories(projectName);
            }

            public String toString() {
                return "listRepositories(" + projectName + ')';
            }
        }, (res, cause) -> {
            if (res != null) {
                for (RepositoryInfo info : res.values()) {
                    if (this.updateLatestKnownRevision(projectName, info.name(), info.headRevision())) continue;
                    return true;
                }
            }
            return false;
        });
    }

    @Override
    public CompletableFuture<Set<String>> listRemovedRepositories(String projectName) {
        return this.delegate.listRemovedRepositories(projectName);
    }

    @Override
    public CompletableFuture<Revision> normalizeRevision(final String projectName, final String repositoryName, final Revision revision) {
        return this.executeWithRetries(new Supplier<CompletableFuture<Revision>>(){

            @Override
            public CompletableFuture<Revision> get() {
                return ReplicationLagTolerantCentralDogma.this.delegate.normalizeRevision(projectName, repositoryName, revision);
            }

            public String toString() {
                return "normalizeRevision(" + projectName + ", " + repositoryName + ", " + revision + ')';
            }
        }, (res, cause) -> {
            if (cause != null) {
                return this.handleRevisionNotFound(projectName, repositoryName, revision, (Throwable)cause);
            }
            if (revision.isRelative()) {
                Revision headRevision = res.forward(-(revision.major() + 1));
                return !this.updateLatestKnownRevision(projectName, repositoryName, headRevision);
            }
            this.updateLatestKnownRevision(projectName, repositoryName, revision);
            return false;
        });
    }

    @Override
    public CompletableFuture<Map<String, EntryType>> listFiles(final String projectName, final String repositoryName, final Revision revision, final PathPattern pathPattern) {
        return this.normalizeRevisionAndExecuteWithRetries(projectName, repositoryName, revision, new Function<Revision, CompletableFuture<Map<String, EntryType>>>(){

            @Override
            public CompletableFuture<Map<String, EntryType>> apply(Revision normRev) {
                return ReplicationLagTolerantCentralDogma.this.delegate.listFiles(projectName, repositoryName, normRev, pathPattern);
            }

            public String toString() {
                return "listFiles(" + projectName + ", " + repositoryName + ", " + revision + ", " + pathPattern + ')';
            }
        });
    }

    @Override
    public <T> CompletableFuture<Entry<T>> getFile(final String projectName, final String repositoryName, final Revision revision, final Query<T> query) {
        return this.normalizeRevisionAndExecuteWithRetries(projectName, repositoryName, revision, new Function<Revision, CompletableFuture<Entry<T>>>(){

            @Override
            public CompletableFuture<Entry<T>> apply(Revision normRev) {
                return ReplicationLagTolerantCentralDogma.this.delegate.getFile(projectName, repositoryName, normRev, query);
            }

            public String toString() {
                return "getFile(" + projectName + ", " + repositoryName + ", " + revision + ", " + query + ')';
            }
        });
    }

    @Override
    public CompletableFuture<Map<String, Entry<?>>> getFiles(final String projectName, final String repositoryName, final Revision revision, final PathPattern pathPattern) {
        return this.normalizeRevisionAndExecuteWithRetries(projectName, repositoryName, revision, new Function<Revision, CompletableFuture<Map<String, Entry<?>>>>(){

            @Override
            public CompletableFuture<Map<String, Entry<?>>> apply(Revision normRev) {
                return ReplicationLagTolerantCentralDogma.this.delegate.getFiles(projectName, repositoryName, normRev, pathPattern);
            }

            public String toString() {
                return "getFiles(" + projectName + ", " + repositoryName + ", " + revision + ", " + pathPattern + ')';
            }
        });
    }

    @Override
    public <T> CompletableFuture<MergedEntry<T>> mergeFiles(final String projectName, final String repositoryName, final Revision revision, final MergeQuery<T> mergeQuery) {
        return this.normalizeRevisionAndExecuteWithRetries(projectName, repositoryName, revision, new Function<Revision, CompletableFuture<MergedEntry<T>>>(){

            @Override
            public CompletableFuture<MergedEntry<T>> apply(Revision normRev) {
                return ReplicationLagTolerantCentralDogma.this.delegate.mergeFiles(projectName, repositoryName, normRev, mergeQuery);
            }

            public String toString() {
                return "mergeFiles(" + projectName + ", " + repositoryName + ", " + revision + ", " + mergeQuery + ')';
            }
        });
    }

    @Override
    public CompletableFuture<List<Commit>> getHistory(final String projectName, final String repositoryName, final Revision from, final Revision to, final PathPattern pathPattern, final int maxCommits) {
        return this.normalizeRevisionsAndExecuteWithRetries(projectName, repositoryName, from, to, new BiFunction<Revision, Revision, CompletableFuture<List<Commit>>>(){

            @Override
            public CompletableFuture<List<Commit>> apply(Revision normFromRev, Revision normToRev) {
                return ReplicationLagTolerantCentralDogma.this.delegate.getHistory(projectName, repositoryName, normFromRev, normToRev, pathPattern, maxCommits);
            }

            public String toString() {
                return "getHistory(" + projectName + ", " + repositoryName + ", " + from + ", " + to + ", " + pathPattern + ", " + maxCommits + ')';
            }
        });
    }

    @Override
    public <T> CompletableFuture<Change<T>> getDiff(final String projectName, final String repositoryName, final Revision from, final Revision to, final Query<T> query) {
        return this.normalizeRevisionsAndExecuteWithRetries(projectName, repositoryName, from, to, new BiFunction<Revision, Revision, CompletableFuture<Change<T>>>(){

            @Override
            public CompletableFuture<Change<T>> apply(Revision normFromRev, Revision normToRev) {
                return ReplicationLagTolerantCentralDogma.this.delegate.getDiff(projectName, repositoryName, normFromRev, normToRev, query);
            }

            public String toString() {
                return "getDiff(" + projectName + ", " + repositoryName + ", " + from + ", " + to + ", " + query + ')';
            }
        });
    }

    @Override
    public CompletableFuture<List<Change<?>>> getDiff(final String projectName, final String repositoryName, final Revision from, final Revision to, final PathPattern pathPattern) {
        return this.normalizeRevisionsAndExecuteWithRetries(projectName, repositoryName, from, to, new BiFunction<Revision, Revision, CompletableFuture<List<Change<?>>>>(){

            @Override
            public CompletableFuture<List<Change<?>>> apply(Revision normFromRev, Revision normToRev) {
                return ReplicationLagTolerantCentralDogma.this.delegate.getDiff(projectName, repositoryName, normFromRev, normToRev, pathPattern);
            }

            public String toString() {
                return "getDiffs(" + projectName + ", " + repositoryName + ", " + from + ", " + to + ", " + pathPattern + ')';
            }
        });
    }

    @Override
    public CompletableFuture<List<Change<?>>> getPreviewDiffs(final String projectName, final String repositoryName, final Revision baseRevision, final Iterable<? extends Change<?>> changes) {
        return this.normalizeRevisionAndExecuteWithRetries(projectName, repositoryName, baseRevision, new Function<Revision, CompletableFuture<List<Change<?>>>>(){

            @Override
            public CompletableFuture<List<Change<?>>> apply(Revision normBaseRev) {
                return ReplicationLagTolerantCentralDogma.this.delegate.getPreviewDiffs(projectName, repositoryName, normBaseRev, changes);
            }

            public String toString() {
                return "getPreviewDiffs(" + projectName + ", " + repositoryName + ", " + baseRevision + ", ...)";
            }
        });
    }

    @Override
    public CompletableFuture<PushResult> push(final String projectName, final String repositoryName, final Revision baseRevision, final String summary, final String detail, final Markup markup, final Iterable<? extends Change<?>> changes) {
        return this.executeWithRetries(new Supplier<CompletableFuture<PushResult>>(){

            @Override
            public CompletableFuture<PushResult> get() {
                return ReplicationLagTolerantCentralDogma.this.delegate.push(projectName, repositoryName, baseRevision, summary, detail, markup, changes);
            }

            public String toString() {
                return "push(" + projectName + ", " + repositoryName + ", " + baseRevision + ", " + summary + ", ...)";
            }
        }, this.pushRetryPredicate(projectName, repositoryName, baseRevision));
    }

    @Override
    public CompletableFuture<PushResult> push(final String projectName, final String repositoryName, final Revision baseRevision, final Author author, final String summary, final String detail, final Markup markup, final Iterable<? extends Change<?>> changes) {
        return this.executeWithRetries(new Supplier<CompletableFuture<PushResult>>(){

            @Override
            public CompletableFuture<PushResult> get() {
                return ReplicationLagTolerantCentralDogma.this.delegate.push(projectName, repositoryName, baseRevision, author, summary, detail, markup, changes);
            }

            public String toString() {
                return "push(" + projectName + ", " + repositoryName + ", " + baseRevision + ", " + summary + ", ...)";
            }
        }, this.pushRetryPredicate(projectName, repositoryName, baseRevision));
    }

    private BiPredicate<PushResult, Throwable> pushRetryPredicate(String projectName, String repositoryName, Revision baseRevision) {
        return (res, cause) -> {
            if (cause != null) {
                return this.handleRevisionNotFound(projectName, repositoryName, baseRevision, (Throwable)cause);
            }
            this.updateLatestKnownRevision(projectName, repositoryName, res.revision());
            return false;
        };
    }

    @Override
    public CompletableFuture<Revision> watchRepository(final String projectName, final String repositoryName, final Revision lastKnownRevision, final PathPattern pathPattern, final long timeoutMillis, final boolean errorOnEntryNotFound) {
        return this.normalizeRevisionAndExecuteWithRetries(projectName, repositoryName, lastKnownRevision, new Function<Revision, CompletableFuture<Revision>>(){

            @Override
            public CompletableFuture<Revision> apply(Revision normLastKnownRevision) {
                return ReplicationLagTolerantCentralDogma.this.delegate.watchRepository(projectName, repositoryName, normLastKnownRevision, pathPattern, timeoutMillis, errorOnEntryNotFound).thenApply(newLastKnownRevision -> {
                    if (newLastKnownRevision != null) {
                        ReplicationLagTolerantCentralDogma.this.updateLatestKnownRevision(projectName, repositoryName, newLastKnownRevision);
                    }
                    return newLastKnownRevision;
                });
            }

            public String toString() {
                return "watchRepository(" + projectName + ", " + repositoryName + ", " + lastKnownRevision + ", " + pathPattern + ", " + timeoutMillis + ", " + errorOnEntryNotFound + ')';
            }
        });
    }

    @Override
    public <T> CompletableFuture<Entry<T>> watchFile(final String projectName, final String repositoryName, final Revision lastKnownRevision, final Query<T> query, final long timeoutMillis, final boolean errorOnEntryNotFound) {
        return this.normalizeRevisionAndExecuteWithRetries(projectName, repositoryName, lastKnownRevision, new Function<Revision, CompletableFuture<Entry<T>>>(){

            @Override
            public CompletableFuture<Entry<T>> apply(Revision normLastKnownRevision) {
                return ReplicationLagTolerantCentralDogma.this.delegate.watchFile(projectName, repositoryName, normLastKnownRevision, query, timeoutMillis, errorOnEntryNotFound).thenApply(entry -> {
                    if (entry != null) {
                        ReplicationLagTolerantCentralDogma.this.updateLatestKnownRevision(projectName, repositoryName, entry.revision());
                    }
                    return entry;
                });
            }

            public String toString() {
                return "watchFile(" + projectName + ", " + repositoryName + ", " + lastKnownRevision + ", " + query + ", " + timeoutMillis + ", " + errorOnEntryNotFound + ')';
            }
        });
    }

    @Override
    public CompletableFuture<Void> whenEndpointReady() {
        return this.delegate.whenEndpointReady();
    }

    private <T> CompletableFuture<T> normalizeRevisionAndExecuteWithRetries(String projectName, String repositoryName, Revision revision, final Function<Revision, CompletableFuture<T>> taskRunner) {
        return this.normalizeRevision(projectName, repositoryName, revision).thenCompose(normRev -> this.executeWithRetries(new Supplier<CompletableFuture<T>>(){
            final /* synthetic */ Revision val$normRev;
            {
                this.val$normRev = revision;
            }

            @Override
            public CompletableFuture<T> get() {
                return (CompletableFuture)taskRunner.apply(this.val$normRev);
            }

            public String toString() {
                return taskRunner + " with " + this.val$normRev;
            }
        }, (res, cause) -> cause != null && this.handleRevisionNotFound(projectName, repositoryName, (Revision)normRev, (Throwable)cause)));
    }

    private <T> CompletableFuture<T> normalizeRevisionsAndExecuteWithRetries(String projectName, String repositoryName, Revision from, Revision to, final BiFunction<Revision, Revision, CompletableFuture<T>> taskRunner) {
        if (to == null) {
            return CompletableFutures.exceptionallyCompletedFuture((Throwable)new NullPointerException("to"));
        }
        if (from == null) {
            return CompletableFutures.exceptionallyCompletedFuture((Throwable)new NullPointerException("from"));
        }
        if (from.isRelative() && to.isRelative() || !from.isRelative() && !to.isRelative()) {
            int distance = to.major() - from.major();
            Revision baseRevision = to.compareTo(from) >= 0 ? to : from;
            return this.normalizeRevision(projectName, repositoryName, baseRevision).thenCompose(normBaseRev -> {
                Revision normFromRev;
                Revision normToRev;
                if (distance >= 0) {
                    normToRev = normBaseRev;
                    normFromRev = normBaseRev.backward(distance);
                } else {
                    normFromRev = normBaseRev;
                    normToRev = normBaseRev.backward(-distance);
                }
                return this.executeWithRetries(new Supplier<CompletableFuture<T>>(){

                    @Override
                    public CompletableFuture<T> get() {
                        return (CompletableFuture)taskRunner.apply(normFromRev, normToRev);
                    }

                    public String toString() {
                        return taskRunner + " with [" + normFromRev + ", " + normToRev + ']';
                    }
                }, (res, cause) -> {
                    if (cause == null) {
                        return false;
                    }
                    return this.handleRevisionNotFound(projectName, repositoryName, (Revision)normBaseRev, (Throwable)cause);
                });
            });
        }
        return CompletableFutures.allAsList((List)ImmutableList.of(this.normalizeRevision(projectName, repositoryName, from), this.normalizeRevision(projectName, repositoryName, to))).thenCompose(normRevs -> {
            final Revision normFromRev = (Revision)normRevs.get(0);
            final Revision normToRev = (Revision)normRevs.get(1);
            return this.executeWithRetries(new Supplier<CompletableFuture<T>>(){

                @Override
                public CompletableFuture<T> get() {
                    return (CompletableFuture)taskRunner.apply(normFromRev, normToRev);
                }

                public String toString() {
                    return taskRunner + " with [" + normFromRev + ", " + normToRev + ']';
                }
            }, (res, cause) -> {
                if (cause == null) {
                    return false;
                }
                Revision normBaseRev = normFromRev.compareTo(normToRev) > 0 ? normFromRev : normToRev;
                return this.handleRevisionNotFound(projectName, repositoryName, normBaseRev, (Throwable)cause);
            });
        });
    }

    private <T> CompletableFuture<T> executeWithRetries(Supplier<CompletableFuture<T>> taskRunner, BiPredicate<T, Throwable> retryPredicate) {
        return this.executeWithRetries(taskRunner, retryPredicate, 0);
    }

    private <T> CompletableFuture<T> executeWithRetries(Supplier<CompletableFuture<T>> taskRunner, BiPredicate<T, Throwable> retryPredicate, int attemptsSoFar) {
        return CompletableFutures.handleCompose((CompletionStage)taskRunner.get(), (res, cause) -> {
            Object currentReplicaHint = this.currentReplicaHintSupplier.get();
            int nextAttemptsSoFar = attemptsSoFar + 1;
            boolean retryRequired = retryPredicate.test((Object)res, (Throwable)cause);
            if (!retryRequired || nextAttemptsSoFar > this.maxRetries) {
                if (retryRequired) {
                    if (currentReplicaHint != null) {
                        logger.warn("[{}] Failed to retrieve the up-to-date data from Central Dogma after {} retries: {} => {}", new Object[]{currentReplicaHint, attemptsSoFar, taskRunner, ReplicationLagTolerantCentralDogma.resultOrCause(res, cause)});
                    } else {
                        logger.warn("Failed to retrieve the up-to-date data from Central Dogma after {} retries: {} => {}", new Object[]{attemptsSoFar, taskRunner, ReplicationLagTolerantCentralDogma.resultOrCause(res, cause)});
                    }
                } else if (logger.isDebugEnabled()) {
                    if (currentReplicaHint != null) {
                        logger.debug("[{}] Retrieved the up-to-date data after {} retries: {} => {}", new Object[]{currentReplicaHint, attemptsSoFar, taskRunner, ReplicationLagTolerantCentralDogma.resultOrCause(res, cause)});
                    } else {
                        logger.debug("Retrieved the up-to-date data after {} retries: {} => {}", new Object[]{attemptsSoFar, taskRunner, ReplicationLagTolerantCentralDogma.resultOrCause(res, cause)});
                    }
                }
                if (cause == null) {
                    return CompletableFuture.completedFuture(res);
                }
                return CompletableFutures.exceptionallyCompletedFuture((Throwable)cause);
            }
            if (logger.isDebugEnabled()) {
                if (currentReplicaHint != null) {
                    logger.debug("[{}] Got the out-of-date data ({} attempt(s) so far): {} => {}", new Object[]{currentReplicaHint, nextAttemptsSoFar, taskRunner, ReplicationLagTolerantCentralDogma.resultOrCause(res, cause)});
                } else {
                    logger.debug("Got the out-of-date data ({} attempt(s) so far): {} => {}", new Object[]{nextAttemptsSoFar, taskRunner, ReplicationLagTolerantCentralDogma.resultOrCause(res, cause)});
                }
            }
            CompletableFuture nextAttemptFuture = new CompletableFuture();
            this.executor().schedule(() -> this.lambda$executeWithRetries$10((Supplier)taskRunner, retryPredicate, nextAttemptsSoFar, nextAttemptFuture), this.retryIntervalMillis, TimeUnit.MILLISECONDS);
            return nextAttemptFuture;
        }).toCompletableFuture();
    }

    private static Throwable peel(Throwable throwable) {
        Throwable cause = throwable.getCause();
        while (cause != null && cause != throwable && (throwable instanceof CompletionException || throwable instanceof ExecutionException)) {
            throwable = cause;
            cause = throwable.getCause();
        }
        return throwable;
    }

    private boolean handleRevisionNotFound(String projectName, String repositoryName, Revision revision, Throwable cause) {
        Objects.requireNonNull(cause, "cause");
        cause = ReplicationLagTolerantCentralDogma.peel(cause);
        if (!(cause instanceof RevisionNotFoundException)) {
            return false;
        }
        Revision latestKnownRevision = this.latestKnownRevision(projectName, repositoryName);
        if (latestKnownRevision == null) {
            return false;
        }
        if (revision.isRelative()) {
            return revision.major() + latestKnownRevision.major() >= 0;
        }
        return revision.major() <= latestKnownRevision.major();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @VisibleForTesting
    Revision latestKnownRevision(String projectName, String repositoryName) {
        Map<RepoId, Revision> map = this.latestKnownRevisions;
        synchronized (map) {
            return this.latestKnownRevisions.get(new RepoId(projectName, repositoryName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateLatestKnownRevision(String projectName, String repositoryName, Revision newRevision) {
        Object currentReplicaHint = this.currentReplicaHintSupplier.get();
        RepoId id = new RepoId(projectName, repositoryName);
        Map<RepoId, Revision> map = this.latestKnownRevisions;
        synchronized (map) {
            Revision oldRevision = this.latestKnownRevisions.get(id);
            if (oldRevision == null) {
                if (currentReplicaHint != null) {
                    logger.debug("[{}] Updating the latest known revision for {}/{} from <unknown> to: {}", new Object[]{currentReplicaHint, projectName, repositoryName, newRevision});
                } else {
                    logger.debug("Updating the latest known revision for {}/{} from <unknown> to: {}", new Object[]{projectName, repositoryName, newRevision});
                }
                this.latestKnownRevisions.put(id, newRevision);
                return true;
            }
            int comparison = oldRevision.compareTo(newRevision);
            if (comparison < 0) {
                if (currentReplicaHint != null) {
                    logger.debug("[{}] Updating the latest known revision for {}/{} from {} to: {}", new Object[]{currentReplicaHint, projectName, repositoryName, oldRevision, newRevision});
                } else {
                    logger.debug("Updating the latest known revision for {}/{} from {} to: {}", new Object[]{projectName, repositoryName, oldRevision, newRevision});
                }
                this.latestKnownRevisions.put(id, newRevision);
                return true;
            }
            if (comparison == 0) {
                if (currentReplicaHint != null) {
                    logger.debug("[{}] The latest known revision for {}/{} stays unchanged at: {}", new Object[]{currentReplicaHint, projectName, repositoryName, newRevision});
                } else {
                    logger.debug("The latest known revision for {}/{} stays unchanged at: {}", new Object[]{projectName, repositoryName, newRevision});
                }
                return true;
            }
            if (currentReplicaHint != null) {
                logger.debug("[{}] An out-of-date latest known revision for {}/{}: {}", new Object[]{currentReplicaHint, projectName, repositoryName, newRevision});
            } else {
                logger.debug("An out-of-date latest known revision for {}/{}: {}", new Object[]{projectName, repositoryName, newRevision});
            }
            return false;
        }
    }

    @Nullable
    private static Object resultOrCause(@Nullable Object res, @Nullable Throwable cause) {
        return res != null ? res : cause;
    }

    private /* synthetic */ void lambda$executeWithRetries$10(Supplier taskRunner, BiPredicate retryPredicate, int nextAttemptsSoFar, CompletableFuture nextAttemptFuture) {
        try {
            this.executeWithRetries(taskRunner, retryPredicate, nextAttemptsSoFar).handle((newRes, newCause) -> {
                if (newCause != null) {
                    nextAttemptFuture.completeExceptionally((Throwable)newCause);
                } else {
                    nextAttemptFuture.complete(newRes);
                }
                return null;
            });
        }
        catch (Throwable t) {
            nextAttemptFuture.completeExceptionally(t);
        }
    }

    private static final class RepoId {
        private final String projectName;
        private final String repositoryName;

        RepoId(String projectName, String repositoryName) {
            this.projectName = projectName;
            this.repositoryName = repositoryName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof RepoId)) {
                return false;
            }
            RepoId that = (RepoId)o;
            return this.projectName.equals(that.projectName) && this.repositoryName.equals(that.repositoryName);
        }

        public int hashCode() {
            return Objects.hash(this.projectName, this.repositoryName);
        }

        public String toString() {
            return this.projectName + '/' + this.repositoryName;
        }
    }
}

