/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.internal.thrift;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.linecorp.centraldogma.common.ChangeFormatException;
import com.linecorp.centraldogma.internal.Jackson;
import com.linecorp.centraldogma.internal.shaded.guava.base.Converter;
import com.linecorp.centraldogma.internal.thrift.Change;
import com.linecorp.centraldogma.internal.thrift.ChangeType;
import javax.annotation.Nullable;

public final class ChangeConverter
extends Converter<com.linecorp.centraldogma.common.Change<?>, Change> {
    public static final Converter<com.linecorp.centraldogma.common.Change<?>, Change> TO_DATA = new ChangeConverter();
    public static final Converter<Change, com.linecorp.centraldogma.common.Change<?>> TO_MODEL = TO_DATA.reverse();

    private ChangeConverter() {
    }

    protected Change doForward(com.linecorp.centraldogma.common.Change<?> value) {
        Change change = new Change(value.path(), ChangeConverter.convertChangeType(value.type()));
        switch (change.getType()) {
            case UPSERT_JSON: 
            case APPLY_JSON_PATCH: {
                try {
                    change.setContent(Jackson.writeValueAsString((Object)value.content()));
                    break;
                }
                catch (JsonProcessingException e) {
                    throw new ChangeFormatException("failed to read a JSON tree", (Throwable)e);
                }
            }
            case UPSERT_TEXT: 
            case APPLY_TEXT_PATCH: 
            case RENAME: {
                change.setContent((String)value.content());
                break;
            }
        }
        return change;
    }

    protected com.linecorp.centraldogma.common.Change<?> doBackward(Change c) {
        switch (c.getType()) {
            case UPSERT_JSON: {
                return com.linecorp.centraldogma.common.Change.ofJsonUpsert((String)c.getPath(), (String)c.getContent());
            }
            case UPSERT_TEXT: {
                return com.linecorp.centraldogma.common.Change.ofTextUpsert((String)c.getPath(), (String)c.getContent());
            }
            case REMOVE: {
                return com.linecorp.centraldogma.common.Change.ofRemoval((String)c.getPath());
            }
            case RENAME: {
                return com.linecorp.centraldogma.common.Change.ofRename((String)c.getPath(), (String)c.getContent());
            }
            case APPLY_JSON_PATCH: {
                return com.linecorp.centraldogma.common.Change.ofJsonPatch((String)c.getPath(), (String)c.getContent());
            }
            case APPLY_TEXT_PATCH: {
                return com.linecorp.centraldogma.common.Change.ofTextPatch((String)c.getPath(), (String)c.getContent());
            }
        }
        throw new Error();
    }

    @Nullable
    private static ChangeType convertChangeType(com.linecorp.centraldogma.common.ChangeType type) {
        if (type == null) {
            return null;
        }
        return ChangeType.valueOf(type.name());
    }
}

