/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.internal.thrift;

import com.linecorp.centraldogma.internal.shaded.guava.base.Converter;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.centraldogma.internal.thrift.MergeQuery;
import com.linecorp.centraldogma.internal.thrift.MergeSource;
import com.linecorp.centraldogma.internal.thrift.QueryType;
import java.util.List;

public final class MergeQueryConverter
extends Converter<com.linecorp.centraldogma.common.MergeQuery<?>, MergeQuery> {
    public static final Converter<com.linecorp.centraldogma.common.MergeQuery<?>, MergeQuery> TO_DATA = new MergeQueryConverter();
    public static final Converter<MergeQuery, com.linecorp.centraldogma.common.MergeQuery<?>> TO_MODEL = TO_DATA.reverse();

    protected MergeQuery doForward(com.linecorp.centraldogma.common.MergeQuery<?> mergeQuery) {
        switch (mergeQuery.type()) {
            case IDENTITY: {
                return new MergeQuery(QueryType.IDENTITY, (List<MergeSource>)MergeQueryConverter.convertMergeSources(mergeQuery), (List<String>)ImmutableList.of());
            }
            case JSON_PATH: {
                return new MergeQuery(QueryType.JSON_PATH, (List<MergeSource>)MergeQueryConverter.convertMergeSources(mergeQuery), mergeQuery.expressions());
            }
        }
        throw new Error();
    }

    protected com.linecorp.centraldogma.common.MergeQuery<?> doBackward(MergeQuery mergeQuery) {
        switch (mergeQuery.type) {
            case IDENTITY: {
                return com.linecorp.centraldogma.common.MergeQuery.ofJson(MergeQueryConverter.convertMergeSources(mergeQuery));
            }
            case JSON_PATH: {
                return com.linecorp.centraldogma.common.MergeQuery.ofJsonPath(MergeQueryConverter.convertMergeSources(mergeQuery), mergeQuery.expressions);
            }
        }
        throw new Error();
    }

    private static ImmutableList<MergeSource> convertMergeSources(com.linecorp.centraldogma.common.MergeQuery<?> mergeQuery) {
        return (ImmutableList)mergeQuery.mergeSources().stream().map(mergeSource -> new MergeSource(mergeSource.path(), mergeSource.isOptional())).collect(ImmutableList.toImmutableList());
    }

    private static List<com.linecorp.centraldogma.common.MergeSource> convertMergeSources(MergeQuery mergeQuery) {
        return (List)mergeQuery.mergeSources.stream().map(mergeSource -> {
            if (mergeSource.isIsOptional()) {
                return com.linecorp.centraldogma.common.MergeSource.ofOptional((String)mergeSource.getPath());
            }
            return com.linecorp.centraldogma.common.MergeSource.ofRequired((String)mergeSource.getPath());
        }).collect(ImmutableList.toImmutableList());
    }

    private MergeQueryConverter() {
    }
}

