/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.internal.thrift;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.internal.Jackson;
import com.linecorp.centraldogma.internal.thrift.Entry;
import com.linecorp.centraldogma.internal.thrift.EntryType;
import java.io.IOException;
import java.io.UncheckedIOException;
import javax.annotation.Nullable;

public final class EntryConverter {
    public static Entry convert(com.linecorp.centraldogma.common.Entry<?> entry) {
        Entry file = new Entry(entry.path(), EntryConverter.convertEntryType(entry.type()));
        switch (entry.type()) {
            case JSON: {
                try {
                    file.setContent(Jackson.writeValueAsString((Object)entry.content()));
                    break;
                }
                catch (JsonProcessingException e) {
                    throw new UncheckedIOException((IOException)((Object)e));
                }
            }
            case TEXT: {
                file.setContent((String)entry.content());
                break;
            }
            case DIRECTORY: {
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupported entry type: " + entry.type());
            }
        }
        return file;
    }

    public static com.linecorp.centraldogma.common.Entry<?> convert(Revision revision, Entry entry) {
        switch (entry.getType()) {
            case JSON: {
                try {
                    JsonNode value = Jackson.readTree((String)entry.getContent());
                    return com.linecorp.centraldogma.common.Entry.ofJson((Revision)revision, (String)entry.getPath(), (JsonNode)value);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            case TEXT: {
                return com.linecorp.centraldogma.common.Entry.ofText((Revision)revision, (String)entry.getPath(), (String)entry.getContent());
            }
            case DIRECTORY: {
                return com.linecorp.centraldogma.common.Entry.ofDirectory((Revision)revision, (String)entry.getPath());
            }
        }
        throw new IllegalArgumentException("unsupported entry type: " + (Object)((Object)entry.getType()));
    }

    @Nullable
    public static EntryType convertEntryType(com.linecorp.centraldogma.common.EntryType type) {
        if (type == null) {
            return null;
        }
        switch (type) {
            case JSON: {
                return EntryType.JSON;
            }
            case TEXT: {
                return EntryType.TEXT;
            }
            case DIRECTORY: {
                return EntryType.DIRECTORY;
            }
        }
        throw new Error();
    }

    @Nullable
    public static com.linecorp.centraldogma.common.EntryType convertEntryType(EntryType type) {
        if (type == null) {
            return null;
        }
        switch (type) {
            case JSON: {
                return com.linecorp.centraldogma.common.EntryType.JSON;
            }
            case TEXT: {
                return com.linecorp.centraldogma.common.EntryType.TEXT;
            }
            case DIRECTORY: {
                return com.linecorp.centraldogma.common.EntryType.DIRECTORY;
            }
        }
        throw new Error();
    }

    private EntryConverter() {
    }
}

