/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.linecorp.centraldogma.internal.Util;
import java.util.Objects;

public class Author {
    public static final Author SYSTEM = new Author("System", "system@localhost.localdomain");
    public static final Author DEFAULT = new Author("User", "user@localhost.localdomain");
    public static final Author UNKNOWN = new Author("Unknown", "nobody@no.where");
    private final String name;
    private final String email;

    public Author(String email) {
        this(email, email);
    }

    @JsonCreator
    public Author(@JsonProperty(value="name") String name, @JsonProperty(value="email") String email) {
        this.name = Objects.requireNonNull(name, "name");
        this.email = Util.validateEmailAddress(email, "email");
    }

    @JsonProperty
    public String name() {
        return this.name;
    }

    @JsonProperty
    public String email() {
        return this.email;
    }

    public int hashCode() {
        return this.email.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Author)) {
            return false;
        }
        Author author = (Author)o;
        return this.email.equals(author.email);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(Util.simpleTypeName(this));
        buf.append("[\"");
        buf.append(this.name);
        buf.append("\" <");
        buf.append(this.email);
        buf.append(">]");
        return buf.toString();
    }
}

