/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.common;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.linecorp.centraldogma.common.ChangeFormatException;
import com.linecorp.centraldogma.common.ChangeType;
import com.linecorp.centraldogma.common.DefaultChange;
import com.linecorp.centraldogma.common.EntryType;
import com.linecorp.centraldogma.internal.Jackson;
import com.linecorp.centraldogma.internal.Util;
import com.linecorp.centraldogma.internal.jsonpatch.JsonPatch;
import com.linecorp.centraldogma.internal.jsonpatch.ReplaceMode;
import com.linecorp.centraldogma.internal.shaded.difflib.DiffUtils;
import com.linecorp.centraldogma.internal.shaded.difflib.Patch;
import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;

@JsonDeserialize(as=DefaultChange.class)
public interface Change<T> {
    public static Change<String> ofTextUpsert(String path, String text) {
        Objects.requireNonNull(text, "text");
        Util.validateFilePath(path, "path");
        if (EntryType.guessFromPath(path) == EntryType.JSON) {
            throw new ChangeFormatException("invalid file type: " + path + " (expected: a non-JSON file). Use Change.ofJsonUpsert() instead");
        }
        return new DefaultChange<String>(path, ChangeType.UPSERT_TEXT, text);
    }

    public static Change<JsonNode> ofJsonUpsert(String path, String jsonText) {
        JsonNode jsonNode;
        Objects.requireNonNull(jsonText, "jsonText");
        try {
            jsonNode = Jackson.readTree(jsonText);
        }
        catch (IOException e) {
            throw new ChangeFormatException("failed to read a value as a JSON tree", e);
        }
        return new DefaultChange<JsonNode>(path, ChangeType.UPSERT_JSON, jsonNode);
    }

    public static Change<JsonNode> ofJsonUpsert(String path, JsonNode jsonNode) {
        Objects.requireNonNull(jsonNode, "jsonNode");
        return new DefaultChange<JsonNode>(path, ChangeType.UPSERT_JSON, jsonNode);
    }

    public static Change<Void> ofRemoval(String path) {
        return new DefaultChange<Object>(path, ChangeType.REMOVE, null);
    }

    public static Change<String> ofRename(String oldPath, String newPath) {
        Util.validateFilePath(oldPath, "oldPath");
        Util.validateFilePath(newPath, "newPath");
        return new DefaultChange<String>(oldPath, ChangeType.RENAME, newPath);
    }

    public static Change<String> ofTextPatch(String path, @Nullable String oldText, String newText) {
        Util.validateFilePath(path, "path");
        Objects.requireNonNull(newText, "newText");
        if (EntryType.guessFromPath(path) == EntryType.JSON) {
            throw new ChangeFormatException("invalid file type: " + path + " (expected: a non-JSON file). Use Change.ofJsonPatch() instead");
        }
        List<String> oldLineList = oldText == null ? Collections.emptyList() : Util.stringToLines(oldText);
        List<String> newLineList = Util.stringToLines(newText);
        Patch<String> patch = DiffUtils.diff(oldLineList, newLineList);
        List<String> unifiedDiff = DiffUtils.generateUnifiedDiff(path, path, oldLineList, patch, 3);
        return new DefaultChange<String>(path, ChangeType.APPLY_TEXT_PATCH, String.join((CharSequence)"\n", unifiedDiff));
    }

    public static Change<String> ofTextPatch(String path, String textPatch) {
        Util.validateFilePath(path, "path");
        Objects.requireNonNull(textPatch, "textPatch");
        if (EntryType.guessFromPath(path) == EntryType.JSON) {
            throw new ChangeFormatException("invalid file type: " + path + " (expected: a non-JSON file). Use Change.ofJsonPatch() instead");
        }
        return new DefaultChange<String>(path, ChangeType.APPLY_TEXT_PATCH, textPatch);
    }

    public static Change<JsonNode> ofJsonPatch(String path, @Nullable String oldJsonText, String newJsonText) {
        JsonNode newJsonNode;
        NullNode oldJsonNode;
        Objects.requireNonNull(newJsonText, "newJsonText");
        try {
            oldJsonNode = oldJsonText == null ? Jackson.nullNode : Jackson.readTree(oldJsonText);
            newJsonNode = Jackson.readTree(newJsonText);
        }
        catch (IOException e) {
            throw new ChangeFormatException("failed to read a value as a JSON tree", e);
        }
        return new DefaultChange<ArrayNode>(path, ChangeType.APPLY_JSON_PATCH, JsonPatch.generate((JsonNode)oldJsonNode, newJsonNode, ReplaceMode.SAFE).toJson());
    }

    public static Change<JsonNode> ofJsonPatch(String path, @Nullable JsonNode oldJsonNode, JsonNode newJsonNode) {
        Objects.requireNonNull(newJsonNode, "newJsonNode");
        if (oldJsonNode == null) {
            oldJsonNode = Jackson.nullNode;
        }
        return new DefaultChange<ArrayNode>(path, ChangeType.APPLY_JSON_PATCH, JsonPatch.generate(oldJsonNode, newJsonNode, ReplaceMode.SAFE).toJson());
    }

    public static Change<JsonNode> ofJsonPatch(String path, String jsonPatchText) {
        JsonNode jsonPatchNode;
        Objects.requireNonNull(jsonPatchText, "jsonPatchText");
        try {
            jsonPatchNode = Jackson.readTree(jsonPatchText);
        }
        catch (IOException e) {
            throw new ChangeFormatException("failed to read a value as a JSON tree", e);
        }
        return Change.ofJsonPatch(path, jsonPatchNode);
    }

    public static Change<JsonNode> ofJsonPatch(String path, JsonNode jsonPatchNode) {
        Objects.requireNonNull(jsonPatchNode, "jsonPatchNode");
        return new DefaultChange<JsonNode>(path, ChangeType.APPLY_JSON_PATCH, jsonPatchNode);
    }

    public static List<Change<?>> fromDirectory(Path sourcePath, String targetPath) {
        List<Change<?>> list;
        block9: {
            Objects.requireNonNull(sourcePath, "sourcePath");
            Util.validateDirPath(targetPath, "targetPath");
            if (!Files.isDirectory(sourcePath, new LinkOption[0])) {
                throw new IllegalArgumentException("sourcePath: " + sourcePath + " (must be a directory)");
            }
            String finalTargetPath = !targetPath.endsWith("/") ? targetPath + '/' : targetPath;
            Stream<Path> s = Files.find(sourcePath, Integer.MAX_VALUE, (p, a) -> a.isRegularFile(), new FileVisitOption[0]);
            try {
                int baseLength = sourcePath.toString().length() + 1;
                list = s.map(sourceFilePath -> {
                    String targetFilePath = finalTargetPath + sourceFilePath.toString().substring(baseLength).replace(File.separatorChar, '/');
                    return Change.fromFile(sourceFilePath, targetFilePath);
                }).collect(Collectors.toList());
                if (s == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (s != null) {
                        try {
                            s.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IOError(e);
                }
            }
            s.close();
        }
        return list;
    }

    public static Change<?> fromFile(Path sourcePath, String targetPath) {
        String content;
        Objects.requireNonNull(sourcePath, "sourcePath");
        Util.validateFilePath(targetPath, "targetPath");
        if (!Files.isRegularFile(sourcePath, new LinkOption[0])) {
            throw new IllegalArgumentException("sourcePath: " + sourcePath + " (must be a regular file)");
        }
        if (targetPath.endsWith("/")) {
            throw new IllegalArgumentException("targetPath: " + targetPath + " (must be a regular file path)");
        }
        EntryType entryType = EntryType.guessFromPath(targetPath);
        try {
            content = new String(Files.readAllBytes(sourcePath), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        switch (entryType) {
            case JSON: {
                return Change.ofJsonUpsert(targetPath, content);
            }
            case TEXT: {
                return Change.ofTextUpsert(targetPath, content);
            }
        }
        throw new Error("unexpected entry type: " + (Object)((Object)entryType));
    }

    @JsonProperty
    public ChangeType type();

    @JsonProperty
    public String path();

    @Nullable
    @JsonProperty
    public T content();

    @Nullable
    public String contentAsText();
}

