/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.common;

import com.fasterxml.jackson.databind.JsonNode;
import com.linecorp.centraldogma.internal.shaded.guava.base.Ascii;
import com.linecorp.centraldogma.internal.shaded.guava.base.Preconditions;
import java.util.Objects;

public enum ChangeType {
    UPSERT_JSON(JsonNode.class),
    UPSERT_TEXT(String.class),
    REMOVE(Void.class),
    RENAME(String.class),
    APPLY_JSON_PATCH(JsonNode.class),
    APPLY_TEXT_PATCH(String.class);

    private final Class<?> contentType;

    private ChangeType(Class<?> contentType) {
        this.contentType = contentType;
    }

    public Class<?> contentType() {
        return this.contentType;
    }

    public static ChangeType parse(String value) {
        Objects.requireNonNull(value, "value");
        Preconditions.checkArgument(!value.isEmpty(), "the value for ChangeType should not be empty.");
        return ChangeType.valueOf(Ascii.toUpperCase(value));
    }
}

