/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.common;

import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.common.Markup;
import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.internal.Util;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import javax.annotation.Nullable;

public class Commit {
    private final Revision revision;
    private final Author author;
    private final long when;
    private final String summary;
    private final String detail;
    private final Markup markup;
    @Nullable
    private String whenAsText;

    public Commit(Revision revision, Author author, String summary, String detail, Markup markup) {
        this(revision, author, System.currentTimeMillis(), summary, detail, markup);
    }

    public Commit(Revision revision, Author author, long when, String summary, String detail, Markup markup) {
        this.revision = Objects.requireNonNull(revision, "revision");
        this.author = Objects.requireNonNull(author, "author");
        this.summary = Objects.requireNonNull(summary, "summary");
        this.detail = Objects.requireNonNull(detail, "detail");
        this.markup = Objects.requireNonNull(markup, "markup");
        this.when = when / 1000L * 1000L;
    }

    public Revision revision() {
        return this.revision;
    }

    public long when() {
        return this.when;
    }

    public String whenAsText() {
        if (this.whenAsText == null) {
            this.whenAsText = DateTimeFormatter.ISO_INSTANT.format(Instant.ofEpochMilli(this.when()));
        }
        return this.whenAsText;
    }

    public Author author() {
        return this.author;
    }

    public String summary() {
        return this.summary;
    }

    public String detail() {
        return this.detail;
    }

    public Markup markup() {
        return this.markup;
    }

    public int hashCode() {
        return (this.revision.hashCode() * 31 + this.author.hashCode()) * 31 + (int)(this.when / 1000L);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Commit)) {
            return false;
        }
        Commit that = (Commit)o;
        return this.revision.equals(that.revision) && this.author.equals(that.author) && this.when == that.when && this.summary.equals(that.summary) && this.detail.equals(that.detail) && this.markup == that.markup;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append(Util.simpleTypeName(this));
        buf.append('[');
        buf.append(this.revision.major());
        buf.append(": author=");
        buf.append(this.author.email());
        buf.append(", when=");
        buf.append(this.whenAsText());
        buf.append(", summary=");
        buf.append(this.summary);
        buf.append(']');
        return buf.toString();
    }
}

