/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.common;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.linecorp.centraldogma.common.EntryType;
import com.linecorp.centraldogma.internal.Jackson;

public interface ContentHolder<T> {
    public EntryType type();

    public T content();

    default public String contentAsText() {
        T content = this.content();
        if (content instanceof JsonNode) {
            try {
                return Jackson.writeValueAsString(content);
            }
            catch (JsonProcessingException e) {
                throw new Error(e);
            }
        }
        return content.toString();
    }

    default public String contentAsPrettyText() {
        T content = this.content();
        if (content instanceof TreeNode) {
            try {
                return Jackson.writeValueAsPrettyString(content);
            }
            catch (JsonProcessingException e) {
                throw new Error(e);
            }
        }
        return content.toString();
    }

    default public JsonNode contentAsJson() throws JsonParseException {
        T content = this.content();
        if (content instanceof JsonNode) {
            return (JsonNode)content;
        }
        return Jackson.readTree(this.contentAsText());
    }

    default public <U> U contentAsJson(Class<U> valueType) throws JsonParseException, JsonMappingException {
        T content = this.content();
        if (content instanceof TreeNode) {
            return Jackson.treeToValue((TreeNode)content, valueType);
        }
        return Jackson.readValue(this.contentAsText(), valueType);
    }
}

