/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.linecorp.centraldogma.common.Change;
import com.linecorp.centraldogma.common.ChangeType;
import com.linecorp.centraldogma.internal.Jackson;
import com.linecorp.centraldogma.internal.Util;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import java.util.Objects;
import javax.annotation.Nullable;

final class DefaultChange<T>
implements Change<T> {
    private final String path;
    private final ChangeType type;
    @Nullable
    private final T content;
    @Nullable
    private String contentAsText;

    @JsonCreator
    static DefaultChange<?> deserialize(@JsonProperty(value="type") ChangeType type, @JsonProperty(value="path") String path, @JsonProperty(value="content") @Nullable JsonNode content) {
        Change<Object> result;
        Objects.requireNonNull(type, "type");
        Class<?> contentType = type.contentType();
        if (contentType == Void.class) {
            if (content != null && !content.isNull()) {
                return DefaultChange.rejectIncompatibleContent(content, Void.class);
            }
        } else if (!(type.contentType() != String.class || content != null && content.isTextual())) {
            return DefaultChange.rejectIncompatibleContent(content, String.class);
        }
        if (type == ChangeType.REMOVE) {
            return (DefaultChange)Change.ofRemoval(path);
        }
        Objects.requireNonNull(content, "content");
        switch (type) {
            case UPSERT_JSON: {
                result = Change.ofJsonUpsert(path, content);
                break;
            }
            case UPSERT_TEXT: {
                result = Change.ofTextUpsert(path, content.asText());
                break;
            }
            case RENAME: {
                result = Change.ofRename(path, content.asText());
                break;
            }
            case APPLY_JSON_PATCH: {
                result = Change.ofJsonPatch(path, content);
                break;
            }
            case APPLY_TEXT_PATCH: {
                result = Change.ofTextPatch(path, content.asText());
                break;
            }
            default: {
                throw new Error();
            }
        }
        return (DefaultChange)result;
    }

    private static DefaultChange<?> rejectIncompatibleContent(@Nullable JsonNode content, Class<?> contentType) {
        throw new IllegalArgumentException("incompatible content: " + content + " (expected: " + contentType.getName() + ')');
    }

    DefaultChange(String path, ChangeType type, @Nullable T content) {
        this.type = Objects.requireNonNull(type, "type");
        if (type.contentType() == JsonNode.class) {
            Util.validateJsonFilePath(path, "path");
        } else {
            Util.validateFilePath(path, "path");
        }
        this.path = path;
        this.content = content;
    }

    @Override
    public String path() {
        return this.path;
    }

    @Override
    public ChangeType type() {
        return this.type;
    }

    @Override
    public T content() {
        return this.content;
    }

    @Override
    @Nullable
    public String contentAsText() {
        if (this.contentAsText != null) {
            return this.contentAsText;
        }
        if (this.content == null) {
            return null;
        }
        if (this.content instanceof CharSequence) {
            this.contentAsText = this.content.toString();
            return this.contentAsText;
        }
        if (this.content instanceof JsonNode) {
            try {
                this.contentAsText = Jackson.writeValueAsString(this.content);
                return this.contentAsText;
            }
            catch (JsonProcessingException e) {
                throw new Error(e);
            }
        }
        throw new Error();
    }

    public int hashCode() {
        return this.type.hashCode() * 31 + this.path.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Change)) {
            return false;
        }
        Change that = (Change)o;
        if (this.type != that.type()) {
            return false;
        }
        if (!this.path.equals(that.path())) {
            return false;
        }
        return Objects.equals(this.content, that.content());
    }

    public String toString() {
        return MoreObjects.toStringHelper(Change.class).add("type", (Object)this.type).add("path", this.path).add("content", this.content).toString();
    }
}

