/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.common;

import com.linecorp.centraldogma.common.PathPattern;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.internal.shaded.guava.base.Preconditions;
import com.linecorp.centraldogma.internal.shaded.guava.math.IntMath;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

final class DefaultPathPattern
implements PathPattern {
    private static final Pattern PATH_PATTERN_PATTERN = Pattern.compile("^[- /*_.0-9a-zA-Z]+$");
    static final String ALL = "/**";
    static final DefaultPathPattern allPattern = new DefaultPathPattern("/**", "/**");
    private final String patterns;
    @Nullable
    private String encoded;

    DefaultPathPattern(Set<String> patterns) {
        this.patterns = patterns.stream().peek(DefaultPathPattern::validatePathPattern).filter(pattern -> !pattern.isEmpty()).map(pattern -> {
            if (pattern.charAt(0) != '/') {
                return "/**/" + pattern;
            }
            return pattern;
        }).collect(Collectors.joining(","));
    }

    private DefaultPathPattern(String patterns, String encoded) {
        this.patterns = patterns;
        this.encoded = encoded;
    }

    @Override
    public String patternString() {
        return this.patterns;
    }

    @Override
    public String encoded() {
        if (this.encoded != null) {
            return this.encoded;
        }
        this.encoded = DefaultPathPattern.encodePathPattern(this.patterns);
        return this.encoded;
    }

    static String encodePathPattern(String pathPattern) {
        int spacePos = pathPattern.indexOf(32);
        if (spacePos < 0) {
            return pathPattern;
        }
        StringBuilder buf = new StringBuilder(IntMath.saturatedMultiply(pathPattern.length(), 2));
        int pos = 0;
        do {
            buf.append(pathPattern, pos, spacePos);
            buf.append("%20");
        } while ((spacePos = pathPattern.indexOf(32, pos = spacePos + 1)) >= 0);
        buf.append(pathPattern, pos, pathPattern.length());
        return buf.toString();
    }

    private static String validatePathPattern(String pattern) {
        Preconditions.checkArgument(PATH_PATTERN_PATTERN.matcher(pattern).matches(), "pattern: %s (expected: %s)", (Object)pattern, PATH_PATTERN_PATTERN);
        return pattern;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("patterns", this.patterns).add("encoded", this.encoded).toString();
    }
}

