/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.common;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonNode;
import com.linecorp.centraldogma.common.ContentHolder;
import com.linecorp.centraldogma.common.EntryNoContentException;
import com.linecorp.centraldogma.common.EntryType;
import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.internal.Jackson;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.internal.shaded.guava.base.Preconditions;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;

public final class Entry<T>
implements ContentHolder<T> {
    private final Revision revision;
    private final String path;
    @Nullable
    private final T content;
    private final EntryType type;
    @Nullable
    private String contentAsText;
    @Nullable
    private String contentAsPrettyText;

    public static Entry<Void> ofDirectory(Revision revision, String path) {
        return new Entry<Object>(revision, path, EntryType.DIRECTORY, null);
    }

    public static Entry<JsonNode> ofJson(Revision revision, String path, JsonNode content) {
        return new Entry<JsonNode>(revision, path, EntryType.JSON, content);
    }

    public static Entry<JsonNode> ofJson(Revision revision, String path, String content) throws JsonParseException {
        return Entry.ofJson(revision, path, Jackson.readTree(content));
    }

    public static Entry<String> ofText(Revision revision, String path, String content) {
        return new Entry<String>(revision, path, EntryType.TEXT, content);
    }

    public static <T> Entry<T> of(Revision revision, String path, EntryType type, @Nullable T content) {
        return new Entry<T>(revision, path, type, content);
    }

    private Entry(Revision revision, String path, EntryType type, @Nullable T content) {
        Objects.requireNonNull(revision, "revision");
        Preconditions.checkArgument(!revision.isRelative(), "revision: %s (expected: absolute revision)", revision);
        this.revision = revision;
        this.path = Objects.requireNonNull(path, "path");
        this.type = Objects.requireNonNull(type, "type");
        Class<?> entryContentType = type.type();
        if (entryContentType == Void.class) {
            Preconditions.checkArgument(content == null, "content: %s (expected: null)", content);
            this.content = null;
        } else {
            Object castContent = entryContentType.cast(Objects.requireNonNull(content, "content"));
            this.content = castContent;
        }
    }

    public Revision revision() {
        return this.revision;
    }

    public String path() {
        return this.path;
    }

    public boolean hasContent() {
        return this.content != null;
    }

    public void ifHasContent(Consumer<? super T> consumer) {
        Objects.requireNonNull(consumer, "consumer");
        if (this.content != null) {
            consumer.accept(this.content);
        }
    }

    @Override
    public EntryType type() {
        return this.type;
    }

    @Override
    public T content() {
        if (this.content == null) {
            throw new EntryNoContentException(this.type, this.revision, this.path);
        }
        return this.content;
    }

    @Override
    public String contentAsText() {
        if (this.contentAsText == null) {
            this.contentAsText = ContentHolder.super.contentAsText();
        }
        return this.contentAsText;
    }

    @Override
    public String contentAsPrettyText() {
        if (this.contentAsPrettyText == null) {
            this.contentAsPrettyText = ContentHolder.super.contentAsPrettyText();
        }
        return this.contentAsPrettyText;
    }

    public int hashCode() {
        return (this.revision.hashCode() * 31 + this.type.hashCode()) * 31 + this.path.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Entry)) {
            return false;
        }
        Entry that = (Entry)o;
        return this.type == that.type && this.revision.equals(that.revision) && this.path.equals(that.path) && Objects.equals(this.content, that.content);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).omitNullValues().add("revision", this.revision.text()).add("path", this.path).add("type", (Object)this.type).add("content", this.hasContent() ? this.contentAsText() : null).toString();
    }
}

