/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.common;

import com.fasterxml.jackson.databind.JsonNode;
import com.linecorp.centraldogma.internal.shaded.guava.base.Ascii;
import java.util.Objects;

public enum EntryType {
    JSON(JsonNode.class),
    TEXT(String.class),
    DIRECTORY(Void.class);

    private final Class<?> type;

    public static EntryType guessFromPath(String path) {
        Objects.requireNonNull(path, "path");
        if (path.isEmpty()) {
            throw new IllegalArgumentException("empty path");
        }
        if (path.charAt(path.length() - 1) == '/') {
            return DIRECTORY;
        }
        if (Ascii.toLowerCase(path).endsWith(".json")) {
            return JSON;
        }
        return TEXT;
    }

    private EntryType(Class<?> type) {
        this.type = type;
    }

    public Class<?> type() {
        return this.type;
    }
}

