/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.common;

import com.linecorp.centraldogma.common.Query;
import com.linecorp.centraldogma.common.QueryType;
import com.linecorp.centraldogma.internal.Util;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

final class IdentityQuery<T>
implements Query<T> {
    private final String path;
    private final QueryType queryType;

    IdentityQuery(String path, QueryType queryType) {
        this.path = Util.validateFilePath(path, "path");
        this.queryType = Objects.requireNonNull(queryType, "queryType");
    }

    @Override
    public String path() {
        return this.path;
    }

    @Override
    public QueryType type() {
        return this.queryType;
    }

    @Override
    public List<String> expressions() {
        return Collections.emptyList();
    }

    @Override
    public T apply(T input) {
        return Objects.requireNonNull(input, "input");
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof IdentityQuery)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        IdentityQuery that = (IdentityQuery)obj;
        return this.path().equals(that.path());
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("path", this.path).add("queryType", (Object)this.queryType).toString();
    }
}

