/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.common;

import com.fasterxml.jackson.databind.JsonNode;
import com.linecorp.centraldogma.common.MergeQuery;
import com.linecorp.centraldogma.common.MergeSource;
import com.linecorp.centraldogma.common.QueryType;
import com.linecorp.centraldogma.internal.Util;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.centraldogma.internal.shaded.guava.collect.Streams;
import java.util.List;
import java.util.Objects;

final class JsonMergeQuery
implements MergeQuery<JsonNode> {
    private final QueryType type;
    private final List<MergeSource> mergeSources;
    private final List<String> jsonPaths;

    JsonMergeQuery(QueryType type, Iterable<MergeSource> mergeSources, Iterable<String> jsonPaths) {
        this.type = Objects.requireNonNull(type, "type");
        this.mergeSources = ImmutableList.copyOf(Objects.requireNonNull(mergeSources, "mergeSources"));
        Streams.stream(Objects.requireNonNull(jsonPaths, "jsonPaths")).forEach(jsonPath -> Util.validateJsonPath(jsonPath, "jsonPath"));
        this.jsonPaths = ImmutableList.copyOf(jsonPaths);
    }

    @Override
    public QueryType type() {
        return this.type;
    }

    @Override
    public List<MergeSource> mergeSources() {
        return this.mergeSources;
    }

    @Override
    public List<String> expressions() {
        return this.jsonPaths;
    }

    public int hashCode() {
        return (this.type.hashCode() * 31 + this.mergeSources.hashCode()) * 31 + this.jsonPaths.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JsonMergeQuery)) {
            return false;
        }
        JsonMergeQuery that = (JsonMergeQuery)o;
        return this.type() == that.type() && this.mergeSources().equals(that.mergeSources()) && this.expressions().equals(that.expressions());
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("type", (Object)this.type()).add("mergeSources", this.mergeSources()).add("expressions", this.expressions()).toString();
    }
}

