/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.common;

import com.fasterxml.jackson.databind.JsonNode;
import com.linecorp.centraldogma.common.Query;
import com.linecorp.centraldogma.common.QueryType;
import com.linecorp.centraldogma.internal.Jackson;
import com.linecorp.centraldogma.internal.Util;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.centraldogma.internal.shaded.guava.collect.Streams;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

final class JsonPathQuery
implements Query<JsonNode> {
    private final String path;
    private final List<String> jsonPaths;
    private int hashCode;
    @Nullable
    private String strVal;

    JsonPathQuery(String path, String ... jsonPaths) {
        this(path, ImmutableList.copyOf(Objects.requireNonNull(jsonPaths, "jsonPaths")));
    }

    JsonPathQuery(String path, Iterable<String> jsonPaths) {
        this.path = Util.validateJsonFilePath(path, "path");
        Streams.stream(Objects.requireNonNull(jsonPaths, "jsonPaths")).forEach(jsonPath -> Util.validateJsonPath(jsonPath, "jsonPath"));
        this.jsonPaths = ImmutableList.copyOf(jsonPaths);
    }

    @Override
    public String path() {
        return this.path;
    }

    @Override
    public QueryType type() {
        return QueryType.JSON_PATH;
    }

    @Override
    public List<String> expressions() {
        return this.jsonPaths;
    }

    public int hashCode() {
        if (this.hashCode != 0) {
            return this.hashCode;
        }
        this.hashCode = this.path.hashCode() * 31 + this.jsonPaths.hashCode();
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JsonPathQuery)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        JsonPathQuery that = (JsonPathQuery)obj;
        return this.hashCode() == that.hashCode() && this.path().equals(that.path()) && this.expressions().equals(that.expressions());
    }

    @Override
    public JsonNode apply(JsonNode input) {
        Objects.requireNonNull(input, "input");
        return Jackson.extractTree(input, this.jsonPaths);
    }

    public String toString() {
        String strVal = this.strVal;
        if (strVal == null) {
            StringBuilder buf = new StringBuilder(this.path.length() + this.jsonPaths.size() * 16 + 16);
            buf.append("JsonPathQuery(");
            buf.append(this.path);
            for (int i = 0; i < this.jsonPaths.size(); ++i) {
                buf.append(", ");
                buf.append(this.jsonPaths.get(i));
            }
            buf.append(')');
            this.strVal = strVal = buf.toString();
        }
        return strVal;
    }
}

