/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.common;

import com.fasterxml.jackson.databind.JsonNode;
import com.linecorp.centraldogma.common.JsonMergeQuery;
import com.linecorp.centraldogma.common.MergeSource;
import com.linecorp.centraldogma.common.QueryType;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.centraldogma.internal.shaded.guava.collect.Iterables;
import java.util.List;
import java.util.Objects;

public interface MergeQuery<T> {
    public static MergeQuery<JsonNode> ofJson(MergeSource ... mergeSources) {
        return MergeQuery.ofJson(ImmutableList.copyOf(Objects.requireNonNull(mergeSources, "mergeSources")));
    }

    public static MergeQuery<JsonNode> ofJson(Iterable<MergeSource> mergeSources) {
        return new JsonMergeQuery(QueryType.IDENTITY, mergeSources, ImmutableList.of());
    }

    public static MergeQuery<JsonNode> ofJsonPath(Iterable<MergeSource> mergeSources, String ... jsonPaths) {
        return MergeQuery.ofJsonPath(mergeSources, ImmutableList.copyOf(Objects.requireNonNull(jsonPaths, "jsonPaths")));
    }

    public static MergeQuery<JsonNode> ofJsonPath(Iterable<MergeSource> mergeSources, Iterable<String> jsonPaths) {
        if (Iterables.isEmpty(Objects.requireNonNull(jsonPaths, "jsonPaths"))) {
            return MergeQuery.ofJson(mergeSources);
        }
        return new JsonMergeQuery(QueryType.JSON_PATH, mergeSources, jsonPaths);
    }

    public static MergeQuery<?> of(QueryType type, Iterable<MergeSource> mergeSources, Iterable<String> expressions) {
        Objects.requireNonNull(type, "type");
        switch (type) {
            case IDENTITY: {
                return MergeQuery.ofJson(mergeSources);
            }
            case JSON_PATH: {
                return MergeQuery.ofJsonPath(mergeSources, expressions);
            }
        }
        throw new IllegalArgumentException("Illegal query type: " + type.name());
    }

    public QueryType type();

    public List<MergeSource> mergeSources();

    public List<String> expressions();
}

