/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.common;

import com.linecorp.centraldogma.internal.Util;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;

public final class MergeSource {
    private final String path;
    private final boolean optional;

    public static MergeSource ofRequired(String path) {
        return new MergeSource(path, false);
    }

    public static MergeSource ofOptional(String path) {
        return new MergeSource(path, true);
    }

    private MergeSource(String path, boolean optional) {
        this.path = Util.validateFilePath(path, "path");
        this.optional = optional;
    }

    public String path() {
        return this.path;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public int hashCode() {
        return this.path.hashCode() * 31 + Boolean.hashCode(this.optional);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MergeSource)) {
            return false;
        }
        MergeSource that = (MergeSource)o;
        return this.path.equals(that.path) && this.optional == that.optional;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("path", this.path).add("optional", this.optional).toString();
    }
}

