/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.common;

import com.linecorp.centraldogma.common.ContentHolder;
import com.linecorp.centraldogma.common.EntryType;
import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.internal.shaded.guava.base.Preconditions;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public final class MergedEntry<T>
implements ContentHolder<T> {
    private final Revision revision;
    private final EntryType type;
    private final List<String> paths;
    private final T content;
    @Nullable
    private String contentAsText;
    @Nullable
    private String contentAsPrettyText;

    public static <T> MergedEntry<T> of(Revision revision, EntryType type, T content, String ... paths) {
        return new MergedEntry<T>(revision, type, content, ImmutableList.copyOf(Objects.requireNonNull(paths, "paths")));
    }

    public static <T> MergedEntry<T> of(Revision revision, EntryType type, T content, Iterable<String> paths) {
        return new MergedEntry<T>(revision, type, content, paths);
    }

    private MergedEntry(Revision revision, EntryType type, T content, Iterable<String> paths) {
        this.revision = Objects.requireNonNull(revision, "revision");
        this.type = Objects.requireNonNull(type, "type");
        Objects.requireNonNull(content, "content");
        Class<?> entryType = type.type();
        Preconditions.checkArgument(entryType.isAssignableFrom(content.getClass()), "content type: %s (expected: %s)", content.getClass(), entryType);
        this.content = content;
        this.paths = ImmutableList.copyOf(Objects.requireNonNull(paths, "paths"));
    }

    public Revision revision() {
        return this.revision;
    }

    @Override
    public EntryType type() {
        return this.type;
    }

    @Override
    public T content() {
        return this.content;
    }

    public List<String> paths() {
        return this.paths;
    }

    @Override
    public String contentAsText() {
        if (this.contentAsText == null) {
            this.contentAsText = ContentHolder.super.contentAsText();
        }
        return this.contentAsText;
    }

    @Override
    public String contentAsPrettyText() {
        if (this.contentAsPrettyText == null) {
            this.contentAsPrettyText = ContentHolder.super.contentAsPrettyText();
        }
        return this.contentAsPrettyText;
    }

    public int hashCode() {
        return (this.revision.hashCode() * 31 + this.type.hashCode()) * 31 + this.content.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MergedEntry)) {
            return false;
        }
        MergedEntry that = (MergedEntry)o;
        return this.revision.equals(that.revision) && this.type == that.type && this.content.equals(that.content) && this.paths.equals(that.paths);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("revision", this.revision()).add("type", (Object)this.type()).add("content", this.contentAsText()).add("paths", this.paths()).toString();
    }
}

