/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.common;

import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import javax.annotation.Nullable;

public class PushResult {
    private final Revision revision;
    private final long when;
    @Nullable
    private String whenAsText;

    public PushResult(Revision revision, long when) {
        this.revision = Objects.requireNonNull(revision, "revision");
        this.when = when / 1000L * 1000L;
    }

    public Revision revision() {
        return this.revision;
    }

    public long when() {
        return this.when;
    }

    public String whenAsText() {
        if (this.whenAsText == null) {
            this.whenAsText = DateTimeFormatter.ISO_INSTANT.format(Instant.ofEpochMilli(this.when()));
        }
        return this.whenAsText;
    }

    public int hashCode() {
        return this.revision.hashCode() * 31 + (int)(this.when / 1000L);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PushResult)) {
            return false;
        }
        PushResult that = (PushResult)o;
        return this.revision.equals(that.revision) && this.when == that.when;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).addValue(this.revision.text()).add("when", this.whenAsText()).toString();
    }
}

