/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.common;

import com.fasterxml.jackson.databind.JsonNode;
import com.linecorp.centraldogma.common.IdentityQuery;
import com.linecorp.centraldogma.common.JsonPathQuery;
import com.linecorp.centraldogma.common.QueryType;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public interface Query<T>
extends Function<T, T> {
    @Deprecated
    public static Query<Object> identity(String path) {
        return new IdentityQuery<Object>(path, QueryType.IDENTITY);
    }

    public static Query<String> ofText(String path) {
        return new IdentityQuery<String>(path, QueryType.IDENTITY_TEXT);
    }

    public static Query<JsonNode> ofJson(String path) {
        return new IdentityQuery<JsonNode>(path, QueryType.IDENTITY_JSON);
    }

    public static Query<JsonNode> ofJsonPath(String path, String ... jsonPaths) {
        return new JsonPathQuery(path, jsonPaths);
    }

    public static Query<JsonNode> ofJsonPath(String path, Iterable<String> jsonPaths) {
        return new JsonPathQuery(path, jsonPaths);
    }

    public static Query<?> of(QueryType type, String path, String ... expressions) {
        Objects.requireNonNull(type, "type");
        switch (type) {
            case IDENTITY: {
                return new IdentityQuery(path, QueryType.IDENTITY);
            }
            case IDENTITY_TEXT: {
                return new IdentityQuery(path, QueryType.IDENTITY_TEXT);
            }
            case IDENTITY_JSON: {
                return new IdentityQuery(path, QueryType.IDENTITY_JSON);
            }
            case JSON_PATH: {
                Objects.requireNonNull(expressions, "expressions");
                return Query.ofJsonPath(path, expressions);
            }
        }
        throw new IllegalArgumentException("Illegal query type: " + type.name());
    }

    public String path();

    public QueryType type();

    public List<String> expressions();
}

