/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.common;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.linecorp.centraldogma.common.RevisionJsonDeserializer;
import com.linecorp.centraldogma.common.RevisionJsonSerializer;
import com.linecorp.centraldogma.internal.Util;
import com.linecorp.centraldogma.internal.shaded.guava.base.Preconditions;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

@JsonSerialize(using=RevisionJsonSerializer.class)
@JsonDeserialize(using=RevisionJsonDeserializer.class)
public class Revision
implements Comparable<Revision> {
    private static final Pattern REVISION_PATTERN = Pattern.compile("^-?[0-9]+(?:\\.0)?$");
    public static final Revision HEAD = new Revision(-1);
    public static final Revision INIT = new Revision(1);
    private final int major;
    private final String text;

    public Revision(int major) {
        if (major == 0) {
            throw new IllegalArgumentException("major: 0 (expected: a non-zero integer)");
        }
        this.major = major;
        this.text = Revision.generateText(major);
    }

    @Deprecated
    public Revision(int major, int minor) {
        this(major);
        Preconditions.checkArgument(minor == 0, "minor: %s (expected: 0)", minor);
    }

    public Revision(String revisionStr) {
        Objects.requireNonNull(revisionStr, "revisionStr");
        if ("head".equalsIgnoreCase(revisionStr) || "-1".equals(revisionStr)) {
            this.major = Revision.HEAD.major;
        } else {
            if (!REVISION_PATTERN.matcher(revisionStr).matches()) {
                throw Revision.illegalRevisionArgumentException(revisionStr);
            }
            try {
                this.major = Integer.parseInt(!revisionStr.endsWith(".0") ? revisionStr : revisionStr.substring(0, revisionStr.length() - 2));
                if (this.major == 0) {
                    throw Revision.illegalRevisionArgumentException(revisionStr);
                }
            }
            catch (NumberFormatException ignored) {
                throw Revision.illegalRevisionArgumentException(revisionStr);
            }
        }
        this.text = Revision.generateText(this.major);
    }

    public int major() {
        return this.major;
    }

    @Deprecated
    public int minor() {
        return 0;
    }

    public String text() {
        return this.text;
    }

    @Deprecated
    public boolean onMainLane() {
        return true;
    }

    public Revision backward(int count) {
        if (count == 0) {
            return this;
        }
        if (count < 0) {
            throw new IllegalArgumentException("count " + count + " (expected: a non-negative integer)");
        }
        return new Revision(Revision.subtract(this.major, count));
    }

    private static int subtract(int revNum, int delta) {
        if (revNum > 0) {
            return Math.max(1, revNum - delta);
        }
        if (revNum < Integer.MIN_VALUE + delta) {
            return Integer.MIN_VALUE;
        }
        return revNum - delta;
    }

    public Revision forward(int count) {
        if (count == 0) {
            return this;
        }
        if (count < 0) {
            throw new IllegalArgumentException("count " + count + " (expected: a non-negative integer)");
        }
        return new Revision(Revision.add(this.major, count));
    }

    private static int add(int revNum, int delta) {
        if (revNum > 0) {
            if (revNum > Integer.MAX_VALUE - delta) {
                return Integer.MAX_VALUE;
            }
            return revNum + delta;
        }
        return Math.min(-1, revNum + delta);
    }

    public int hashCode() {
        return this.major;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Revision)) {
            return false;
        }
        return this.major == ((Revision)o).major;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(Util.simpleTypeName(this));
        buf.append('(');
        buf.append(this.major);
        buf.append(')');
        return buf.toString();
    }

    @Override
    public int compareTo(Revision o) {
        return Integer.compare(this.major, o.major);
    }

    public boolean isRelative() {
        return this.major < 0;
    }

    private static String generateText(int major) {
        return String.valueOf(major);
    }

    private static IllegalArgumentException illegalRevisionArgumentException(String revisionStr) {
        return new IllegalArgumentException("revisionStr: " + revisionStr + " (expected: \"major\" or \"major.0\" where major is non-zero integer)");
    }
}

