/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.common;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.linecorp.centraldogma.common.Revision;
import java.io.IOException;
import javax.annotation.Nullable;

public class RevisionJsonDeserializer
extends StdDeserializer<Revision> {
    private static final long serialVersionUID = -2337105643062794190L;

    public RevisionJsonDeserializer() {
        super(Revision.class);
    }

    public Revision deserialize(JsonParser p, DeserializationContext ctx) throws IOException {
        JsonNode node = (JsonNode)p.readValueAsTree();
        if (node.isNumber()) {
            RevisionJsonDeserializer.validateRevisionNumber(ctx, node, "major", false);
            return new Revision(node.intValue());
        }
        if (node.isTextual()) {
            try {
                return new Revision(node.textValue());
            }
            catch (IllegalArgumentException e) {
                ctx.reportInputMismatch(Revision.class, e.getMessage(), new Object[0]);
                throw new Error();
            }
        }
        if (!node.isObject()) {
            ctx.reportInputMismatch(Revision.class, "A revision must be a non-zero integer or an object that contains \"major\" and \"minor\" properties.", new Object[0]);
            throw new Error();
        }
        JsonNode majorNode = node.get("major");
        JsonNode minorNode = node.get("minor");
        RevisionJsonDeserializer.validateRevisionNumber(ctx, majorNode, "major", false);
        int major = majorNode.intValue();
        if (minorNode != null) {
            RevisionJsonDeserializer.validateRevisionNumber(ctx, minorNode, "minor", true);
            if (minorNode.intValue() != 0) {
                ctx.reportInputMismatch(Revision.class, "A revision must not have a non-zero \"minor\" property.", new Object[0]);
            }
        }
        return new Revision(major);
    }

    private static void validateRevisionNumber(DeserializationContext ctx, @Nullable JsonNode node, String type, boolean zeroAllowed) throws JsonMappingException {
        if (node == null) {
            ctx.reportInputMismatch(Revision.class, "missing %s revision number", new Object[]{type});
            throw new Error();
        }
        if (!node.canConvertToInt() || !zeroAllowed && node.intValue() == 0) {
            ctx.reportInputMismatch(Revision.class, "A %s revision number must be %s integer.", new Object[]{type, zeroAllowed ? "an" : "a non-zero"});
            throw new Error();
        }
    }
}

