/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.common;

import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import java.util.Objects;

public class RevisionRange {
    private final Revision from;
    private final Revision to;

    public RevisionRange(int from, int to) {
        this(new Revision(from), new Revision(to));
    }

    public RevisionRange(Revision from, Revision to) {
        this.from = Objects.requireNonNull(from, "from");
        this.to = Objects.requireNonNull(to, "to");
    }

    public Revision from() {
        return this.from;
    }

    public Revision to() {
        return this.to;
    }

    public RevisionRange toAscending() {
        if (this.isAscending() || this.from.equals(this.to)) {
            return this;
        }
        return new RevisionRange(this.to, this.from);
    }

    public RevisionRange toDescending() {
        if (this.isAscending()) {
            return new RevisionRange(this.to, this.from);
        }
        return this;
    }

    public boolean isAscending() {
        if (this.from.isRelative() != this.to.isRelative()) {
            throw new IllegalStateException("both of from: '" + this.from + "' and to: '" + this.to + "' should be absolute or relative.");
        }
        return this.from.compareTo(this.to) < 0;
    }

    public boolean isRelative() {
        return this.from.isRelative() || this.to.isRelative();
    }

    public int hashCode() {
        return this.from.hashCode() * 31 + this.to.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RevisionRange that = (RevisionRange)o;
        return this.from.equals(that.from) && this.to.equals(that.to);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("from", this.from).add("to", this.to).toString();
    }
}

