/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.internal;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;

final class DeletingFileVisitor
extends SimpleFileVisitor<Path> {
    static final FileVisitor<Path> INSTANCE = new DeletingFileVisitor();

    DeletingFileVisitor() {
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
        DeletingFileVisitor.delete(file);
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFileFailed(Path file, IOException exc) {
        DeletingFileVisitor.delete(file);
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult postVisitDirectory(Path dir, IOException e) throws IOException {
        DeletingFileVisitor.delete(dir);
        if (e == null) {
            return FileVisitResult.CONTINUE;
        }
        throw e;
    }

    private static void delete(Path p) {
        File f = p.toFile();
        f.delete();
        f.setWritable(true, true);
    }
}

