/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.internal;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.io.JsonStringEncoder;
import com.fasterxml.jackson.core.io.SegmentedStringWriter;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.datatype.jsr310.deser.InstantDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.InstantSerializer;
import com.linecorp.centraldogma.common.QueryExecutionException;
import com.linecorp.centraldogma.common.QuerySyntaxException;
import com.linecorp.centraldogma.internal.shaded.guava.base.Preconditions;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.centraldogma.internal.shaded.guava.collect.Iterables;
import com.linecorp.centraldogma.internal.shaded.jsonpath.Configuration;
import com.linecorp.centraldogma.internal.shaded.jsonpath.JsonPath;
import com.linecorp.centraldogma.internal.shaded.jsonpath.Option;
import com.linecorp.centraldogma.internal.shaded.jsonpath.Predicate;
import com.linecorp.centraldogma.internal.shaded.jsonpath.spi.json.JacksonJsonNodeJsonProvider;
import com.linecorp.centraldogma.internal.shaded.jsonpath.spi.json.JsonProvider;
import com.linecorp.centraldogma.internal.shaded.jsonpath.spi.mapper.JacksonMappingProvider;
import com.linecorp.centraldogma.internal.shaded.jsonpath.spi.mapper.MappingProvider;
import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.io.Writer;
import java.time.Instant;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;

public final class Jackson {
    private static final ObjectMapper compactMapper = new ObjectMapper();
    private static final ObjectMapper prettyMapper = new ObjectMapper();
    private static final JsonFactory compactFactory;
    private static final JsonFactory prettyFactory;
    private static final Configuration jsonPathCfg;
    public static final NullNode nullNode;

    public static void registerModules(Module ... modules) {
        compactMapper.registerModules(modules);
        prettyMapper.registerModules(modules);
    }

    public static void registerSubtypes(NamedType ... subtypes) {
        compactMapper.registerSubtypes(subtypes);
        prettyMapper.registerSubtypes(subtypes);
    }

    public static void registerSubtypes(Class<?> ... subtypes) {
        compactMapper.registerSubtypes((Class[])subtypes);
        prettyMapper.registerSubtypes((Class[])subtypes);
    }

    public static <T> T readValue(String data, Class<T> type) throws JsonParseException, JsonMappingException {
        try {
            return (T)compactMapper.readValue(data, type);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw e;
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public static <T> T readValue(byte[] data, Class<T> type) throws JsonParseException, JsonMappingException {
        try {
            return (T)compactMapper.readValue(data, type);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw e;
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public static <T> T readValue(File file, Class<T> type) throws JsonParseException, JsonMappingException {
        try {
            return (T)compactMapper.readValue(file, type);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw e;
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public static <T> T readValue(String data, TypeReference<T> typeReference) throws JsonParseException, JsonMappingException {
        try {
            return (T)compactMapper.readValue(data, typeReference);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw e;
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public static <T> T readValue(byte[] data, TypeReference<T> typeReference) throws JsonParseException, JsonMappingException {
        try {
            return (T)compactMapper.readValue(data, typeReference);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw e;
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public static <T> T readValue(File file, TypeReference<T> typeReference) throws IOException {
        return (T)compactMapper.readValue(file, typeReference);
    }

    public static JsonNode readTree(String data) throws JsonParseException {
        try {
            return compactMapper.readTree(data);
        }
        catch (JsonParseException e) {
            throw e;
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public static JsonNode readTree(byte[] data) throws JsonParseException {
        try {
            return compactMapper.readTree(data);
        }
        catch (JsonParseException e) {
            throw e;
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public static byte[] writeValueAsBytes(Object value) throws JsonProcessingException {
        return compactMapper.writeValueAsBytes(value);
    }

    public static String writeValueAsString(Object value) throws JsonProcessingException {
        return compactMapper.writeValueAsString(value);
    }

    public static String writeValueAsPrettyString(Object value) throws JsonProcessingException {
        JsonFactory factory = prettyMapper.getFactory();
        SegmentedStringWriter sw = new SegmentedStringWriter(factory._getBufferRecycler());
        try {
            JsonGenerator g = prettyMapper.getFactory().createGenerator((Writer)sw);
            g.setPrettyPrinter((PrettyPrinter)new PrettyPrinterImpl());
            prettyMapper.writeValue(g, value);
        }
        catch (JsonProcessingException e) {
            throw e;
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        return sw.getAndClear();
    }

    public static <T extends JsonNode> T valueToTree(Object value) {
        return (T)compactMapper.valueToTree(value);
    }

    public static <T> T treeToValue(TreeNode node, Class<T> valueType) throws JsonParseException, JsonMappingException {
        try {
            return (T)compactMapper.treeToValue(node, valueType);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw e;
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(e);
        }
    }

    public static <T> T convertValue(Object fromValue, Class<T> toValueType) {
        return (T)compactMapper.convertValue(fromValue, toValueType);
    }

    public static <T> T convertValue(Object fromValue, TypeReference<T> toValueTypeRef) {
        return (T)compactMapper.convertValue(fromValue, toValueTypeRef);
    }

    public static JsonGenerator createGenerator(Writer writer) throws IOException {
        return compactFactory.createGenerator(writer);
    }

    public static JsonGenerator createPrettyGenerator(Writer writer) throws IOException {
        JsonGenerator generator = prettyFactory.createGenerator(writer);
        generator.useDefaultPrettyPrinter();
        return generator;
    }

    public static String textValue(JsonNode node, String defaultValue) {
        return node != null && node.getNodeType() == JsonNodeType.STRING ? node.textValue() : defaultValue;
    }

    public static JsonNode extractTree(JsonNode jsonNode, Iterable<String> jsonPaths) {
        for (String jsonPath : jsonPaths) {
            jsonNode = Jackson.extractTree(jsonNode, jsonPath);
        }
        return jsonNode;
    }

    public static JsonNode extractTree(JsonNode jsonNode, String jsonPath) {
        JsonPath compiledJsonPath;
        Objects.requireNonNull(jsonNode, "jsonNode");
        Objects.requireNonNull(jsonPath, "jsonPath");
        try {
            compiledJsonPath = JsonPath.compile(jsonPath, new Predicate[0]);
        }
        catch (Exception e) {
            throw new QuerySyntaxException("invalid JSON path: " + jsonPath, e);
        }
        try {
            return JsonPath.parse(jsonNode, jsonPathCfg).read(compiledJsonPath, JsonNode.class);
        }
        catch (Exception e) {
            throw new QueryExecutionException("JSON path evaluation failed: " + jsonPath, e);
        }
    }

    public static String escapeText(String text) {
        JsonStringEncoder enc = JsonStringEncoder.getInstance();
        return new String(enc.quoteAsString(text));
    }

    public static JsonNode mergeTree(JsonNode ... jsonNodes) {
        return Jackson.mergeTree(ImmutableList.copyOf(Objects.requireNonNull(jsonNodes, "jsonNodes")));
    }

    public static JsonNode mergeTree(Iterable<JsonNode> jsonNodes) {
        Objects.requireNonNull(jsonNodes, "jsonNodes");
        int size = Iterables.size(jsonNodes);
        Preconditions.checkArgument(size > 0, "jsonNodes is empty.");
        Iterator<JsonNode> it = jsonNodes.iterator();
        JsonNode first = it.next();
        JsonNode merged = first.deepCopy();
        StringBuilder fieldNameAppender = new StringBuilder("/");
        while (it.hasNext()) {
            JsonNode addition = it.next();
            merged = Jackson.traverse(merged, addition, fieldNameAppender, true, true);
        }
        if (size > 2) {
            Jackson.traverse(first, merged, fieldNameAppender, false, true);
        }
        return merged;
    }

    private static JsonNode traverse(JsonNode base, JsonNode update, StringBuilder fieldNameAppender, boolean isMerging, boolean isRoot) {
        if (base.isObject() && update.isObject()) {
            ObjectNode baseObject = (ObjectNode)base;
            Iterator fieldNames = update.fieldNames();
            while (fieldNames.hasNext()) {
                String fieldName = (String)fieldNames.next();
                JsonNode baseValue = baseObject.get(fieldName);
                JsonNode updateValue = update.get(fieldName);
                if (baseValue == null || baseValue.isNull() || updateValue.isNull()) {
                    if (!isMerging) continue;
                    baseObject.set(fieldName, updateValue);
                    continue;
                }
                int length = fieldNameAppender.length();
                fieldNameAppender.append(fieldName);
                fieldNameAppender.append('/');
                JsonNode traversed = Jackson.traverse(baseValue, updateValue, fieldNameAppender, isMerging, false);
                if (isMerging) {
                    baseObject.set(fieldName, traversed);
                }
                fieldNameAppender.delete(length, fieldNameAppender.length());
            }
            return base;
        }
        if (isRoot || base.getNodeType() != update.getNodeType() && (!base.isNull() || !update.isNull())) {
            throw new QueryExecutionException("Failed to merge tree. " + fieldNameAppender + " type: " + update.getNodeType() + " (expected: " + (isRoot ? JsonNodeType.OBJECT : base.getNodeType()) + ')');
        }
        return update;
    }

    private Jackson() {
    }

    static {
        compactMapper.disable(SerializationFeature.INDENT_OUTPUT);
        prettyMapper.enable(SerializationFeature.INDENT_OUTPUT);
        compactMapper.enable(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS);
        prettyMapper.enable(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS);
        Jackson.registerModules(new Module[]{new SimpleModule().addSerializer(Instant.class, (JsonSerializer)InstantSerializer.INSTANCE).addDeserializer(Instant.class, (JsonDeserializer)InstantDeserializer.INSTANT)});
        compactFactory = new JsonFactory((ObjectCodec)compactMapper);
        prettyFactory = new JsonFactory((ObjectCodec)prettyMapper);
        jsonPathCfg = Configuration.builder().jsonProvider(new JacksonJsonNodeJsonProvider()).mappingProvider(new JacksonMappingProvider(prettyMapper)).build();
        if (Configuration.class.getPackage().getName().endsWith(".shaded.jsonpath")) {
            Configuration.setDefaults(new Configuration.Defaults(){

                @Override
                public JsonProvider jsonProvider() {
                    return jsonPathCfg.jsonProvider();
                }

                @Override
                public Set<Option> options() {
                    return jsonPathCfg.getOptions();
                }

                @Override
                public MappingProvider mappingProvider() {
                    return jsonPathCfg.mappingProvider();
                }
            });
        }
        nullNode = NullNode.instance;
    }

    private static class PrettyPrinterImpl
    extends DefaultPrettyPrinter {
        private static final long serialVersionUID = 8408886209309852098L;
        private static final DefaultPrettyPrinter.Indenter objectIndenter = new DefaultIndenter("  ", "\n");

        PrettyPrinterImpl() {
            this._objectFieldValueSeparatorWithSpaces = ": ";
            this._objectIndenter = objectIndenter;
        }
    }
}

