/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.internal;

import com.linecorp.centraldogma.internal.DeletingFileVisitor;
import com.linecorp.centraldogma.internal.shaded.guava.base.Preconditions;
import com.linecorp.centraldogma.internal.shaded.jsonpath.JsonPath;
import com.linecorp.centraldogma.internal.shaded.jsonpath.Predicate;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Util {
    private static final Pattern FILE_NAME_PATTERN = Pattern.compile("^(?:[-_0-9a-zA-Z](?:[-_.0-9a-zA-Z]*[-_0-9a-zA-Z])?)+$");
    private static final Pattern FILE_PATH_PATTERN = Pattern.compile("^(?:/[-_0-9a-zA-Z](?:[-_.0-9a-zA-Z]*[-_0-9a-zA-Z])?)+$");
    private static final Pattern JSON_FILE_PATH_PATTERN = Pattern.compile("^(?:/[-_0-9a-zA-Z](?:[-_.0-9a-zA-Z]*[-_0-9a-zA-Z])?)+\\.(?i)json$");
    private static final Pattern DIR_PATH_PATTERN = Pattern.compile("^(?:/[-_0-9a-zA-Z](?:[-_.0-9a-zA-Z]*[-_0-9a-zA-Z])?)*/?$");
    private static final Pattern PATH_PATTERN_PATTERN = Pattern.compile("^[- /*_.,0-9a-zA-Z]+$");
    private static final Pattern EMAIL_PATTERN = Pattern.compile("^[_A-Za-z0-9-+]+(?:\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(?:\\.[A-Za-z0-9]+)*(?:\\.[A-Za-z]{2,})$");
    private static final Pattern GENERAL_EMAIL_PATTERN = Pattern.compile("^[_A-Za-z0-9-+]+(?:\\.[_A-Za-z0-9-]+)*@(.+)$");
    private static final Pattern PROJECT_AND_REPO_NAME_PATTERN = Pattern.compile("^[0-9A-Za-z](?:[-+_0-9A-Za-z.]*[0-9A-Za-z])?$");

    public static String validateFileName(String name, String paramName) {
        Objects.requireNonNull(name, paramName);
        Preconditions.checkArgument(Util.isValidFileName(name), "%s: %s (expected: %s)", paramName, name, FILE_NAME_PATTERN);
        return name;
    }

    public static boolean isValidFileName(String name) {
        Objects.requireNonNull(name, "name");
        return !name.isEmpty() && FILE_NAME_PATTERN.matcher(name).matches();
    }

    public static String validateFilePath(String path, String paramName) {
        Objects.requireNonNull(path, paramName);
        Preconditions.checkArgument(Util.isValidFilePath(path), "%s: %s (expected: %s)", paramName, path, FILE_PATH_PATTERN);
        return path;
    }

    public static boolean isValidFilePath(String path) {
        Objects.requireNonNull(path, "path");
        return !path.isEmpty() && path.charAt(0) == '/' && FILE_PATH_PATTERN.matcher(path).matches();
    }

    public static String validateJsonFilePath(String path, String paramName) {
        Objects.requireNonNull(path, paramName);
        Preconditions.checkArgument(Util.isValidJsonFilePath(path), "%s: %s (expected: %s)", paramName, path, JSON_FILE_PATH_PATTERN);
        return path;
    }

    public static boolean isValidJsonFilePath(String path) {
        Objects.requireNonNull(path, "path");
        return !path.isEmpty() && path.charAt(0) == '/' && JSON_FILE_PATH_PATTERN.matcher(path).matches();
    }

    public static String validateJsonPath(String jsonPath, String paramName) {
        Objects.requireNonNull(jsonPath, paramName);
        Preconditions.checkArgument(Util.isValidJsonPath(jsonPath), "%s: %s (expected: a valid JSON path)", (Object)paramName, jsonPath);
        return jsonPath;
    }

    public static boolean isValidJsonPath(String jsonPath) {
        try {
            JsonPath.compile(jsonPath, new Predicate[0]);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String validateDirPath(String path, String paramName) {
        Objects.requireNonNull(path, paramName);
        Preconditions.checkArgument(Util.isValidDirPath(path), "%s: %s (expected: %s)", paramName, path, DIR_PATH_PATTERN);
        return path;
    }

    public static boolean isValidDirPath(String path) {
        return Util.isValidDirPath(path, false);
    }

    public static boolean isValidDirPath(String path, boolean mustEndWithSlash) {
        Objects.requireNonNull(path);
        if (mustEndWithSlash && !path.endsWith("/")) {
            return false;
        }
        return !path.isEmpty() && path.charAt(0) == '/' && DIR_PATH_PATTERN.matcher(path).matches();
    }

    public static String validatePathPattern(String pathPattern, String paramName) {
        Objects.requireNonNull(pathPattern, paramName);
        Preconditions.checkArgument(Util.isValidPathPattern(pathPattern), "%s: %s (expected: %s)", paramName, pathPattern, PATH_PATTERN_PATTERN);
        return pathPattern;
    }

    public static boolean isValidPathPattern(String pathPattern) {
        Objects.requireNonNull(pathPattern, "pathPattern");
        return PATH_PATTERN_PATTERN.matcher(pathPattern).matches();
    }

    public static String validateProjectName(String projectName, String paramName) {
        Objects.requireNonNull(projectName, paramName);
        Preconditions.checkArgument(Util.isValidProjectName(projectName), "%s: %s (expected: %s)", paramName, projectName, PROJECT_AND_REPO_NAME_PATTERN);
        return projectName;
    }

    public static boolean isValidProjectName(String projectName) {
        Objects.requireNonNull(projectName, "projectName");
        return PROJECT_AND_REPO_NAME_PATTERN.matcher(projectName).matches();
    }

    public static String validateRepositoryName(String repoName, String paramName) {
        Objects.requireNonNull(repoName, paramName);
        Preconditions.checkArgument(Util.isValidRepositoryName(repoName), "%s: %s (expected: %s)", paramName, repoName, PROJECT_AND_REPO_NAME_PATTERN);
        return repoName;
    }

    public static boolean isValidRepositoryName(String repoName) {
        Objects.requireNonNull(repoName, "repoName");
        return PROJECT_AND_REPO_NAME_PATTERN.matcher(repoName).matches();
    }

    public static String validateEmailAddress(String emailAddr, String paramName) {
        Objects.requireNonNull(emailAddr, paramName);
        Preconditions.checkArgument(Util.isValidEmailAddress(emailAddr), "%s: %s (expected: a valid e-mail address)", (Object)paramName, emailAddr);
        return emailAddr;
    }

    public static boolean isValidEmailAddress(String emailAddr) {
        Objects.requireNonNull(emailAddr, "emailAddr");
        if (EMAIL_PATTERN.matcher(emailAddr).matches()) {
            return true;
        }
        Matcher m = GENERAL_EMAIL_PATTERN.matcher(emailAddr);
        if (m.matches()) {
            String domainPart = m.group(1);
            return Util.isValidIpV4Address(domainPart) || Util.isValidIpV6Address(domainPart);
        }
        return false;
    }

    public static String toEmailAddress(String emailAddr, String paramName) {
        Objects.requireNonNull(emailAddr, paramName);
        if (Util.isValidEmailAddress(emailAddr)) {
            return emailAddr;
        }
        return emailAddr + "@localhost.localdomain";
    }

    public static String emailToUsername(String emailAddr, String paramName) {
        Util.validateEmailAddress(emailAddr, paramName);
        return emailAddr.substring(0, emailAddr.indexOf(64));
    }

    public static List<String> stringToLines(String str) {
        BufferedReader reader = new BufferedReader(new StringReader(str));
        ArrayList<String> lines = new ArrayList<String>(128);
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                lines.add(line);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return lines;
    }

    public static String simpleTypeName(Object obj) {
        if (obj == null) {
            return "null";
        }
        return Util.simpleTypeName(obj.getClass(), false);
    }

    public static String simpleTypeName(Class<?> clazz) {
        return Util.simpleTypeName(clazz, false);
    }

    public static String simpleTypeName(Class<?> clazz, boolean decapitalize) {
        if (clazz == null) {
            return "null";
        }
        String className = clazz.getName();
        int lastDotIdx = className.lastIndexOf(46);
        if (lastDotIdx >= 0) {
            className = className.substring(lastDotIdx + 1);
        }
        if (!decapitalize) {
            return className;
        }
        StringBuilder buf = new StringBuilder(className.length());
        boolean lowercase = true;
        for (int i = 0; i < className.length(); ++i) {
            char c2;
            char c1 = className.charAt(i);
            if (lowercase) {
                c2 = Character.toLowerCase(c1);
                if (c1 == c2) {
                    lowercase = false;
                }
            } else {
                c2 = c1;
            }
            buf.append(c2);
        }
        return buf.toString();
    }

    public static <T> T unsafeCast(Object o) {
        return (T)o;
    }

    public static <T> Iterable<T> requireNonNullElements(Iterable<T> values, String name) {
        Objects.requireNonNull(values, name);
        int i = 0;
        for (T v : values) {
            if (v == null) {
                throw new NullPointerException(name + '[' + i + ']');
            }
            ++i;
        }
        return values;
    }

    private static boolean isValidIpV4Address(String ip) {
        return Util.isValidIpV4Address(ip, 0, ip.length());
    }

    private static boolean isValidIpV4Address(String ip, int from, int toExcluded) {
        int i;
        int len = toExcluded - from;
        return len <= 15 && len >= 7 && (i = ip.indexOf(46, from + 1)) > 0 && Util.isValidIpV4Word(ip, from, i) && (i = ip.indexOf(46, from = i + 2)) > 0 && Util.isValidIpV4Word(ip, from - 1, i) && (i = ip.indexOf(46, from = i + 2)) > 0 && Util.isValidIpV4Word(ip, from - 1, i) && Util.isValidIpV4Word(ip, i + 1, toExcluded);
    }

    private static boolean isValidIpV4Word(CharSequence word, int from, int toExclusive) {
        char c0;
        int len = toExclusive - from;
        if (len < 1 || len > 3 || (c0 = word.charAt(from)) < '0') {
            return false;
        }
        if (len == 3) {
            char c2;
            char c1 = word.charAt(from + 1);
            return c1 >= '0' && (c2 = word.charAt(from + 2)) >= '0' && (c0 <= '1' && c1 <= '9' && c2 <= '9' || c0 == '2' && c1 <= '5' && (c2 <= '5' || c1 < '5' && c2 <= '9'));
        }
        return c0 <= '9' && (len == 1 || Util.isValidNumericChar(word.charAt(from + 1)));
    }

    private static boolean isValidIpV6Address(String ip) {
        int compressBegin;
        int colons;
        int start;
        int end = ip.length();
        if (end < 2) {
            return false;
        }
        char c = ip.charAt(0);
        if (c == '[') {
            if (ip.charAt(--end) != ']') {
                return false;
            }
            start = 1;
            c = ip.charAt(1);
        } else {
            start = 0;
        }
        if (c == ':') {
            if (ip.charAt(start + 1) != ':') {
                return false;
            }
            colons = 2;
            compressBegin = start;
            start += 2;
        } else {
            colons = 0;
            compressBegin = -1;
        }
        int wordLen = 0;
        block5: for (int i = start; i < end; ++i) {
            c = ip.charAt(i);
            if (Util.isValidHexChar(c)) {
                if (wordLen < 4) {
                    ++wordLen;
                    continue;
                }
                return false;
            }
            switch (c) {
                case ':': {
                    if (colons > 7) {
                        return false;
                    }
                    if (ip.charAt(i - 1) == ':') {
                        if (compressBegin >= 0) {
                            return false;
                        }
                        compressBegin = i - 1;
                    } else {
                        wordLen = 0;
                    }
                    ++colons;
                    continue block5;
                }
                case '.': {
                    if (compressBegin < 0 && colons != 6 || colons == 7 && compressBegin >= start || colons > 7) {
                        return false;
                    }
                    int ipv4Start = i - wordLen;
                    int j = ipv4Start - 2;
                    if (Util.isValidIPv4MappedChar(ip.charAt(j))) {
                        if (!(Util.isValidIPv4MappedChar(ip.charAt(j - 1)) && Util.isValidIPv4MappedChar(ip.charAt(j - 2)) && Util.isValidIPv4MappedChar(ip.charAt(j - 3)))) {
                            return false;
                        }
                        j -= 5;
                    }
                    while (j >= start) {
                        char tmpChar = ip.charAt(j);
                        if (tmpChar != '0' && tmpChar != ':') {
                            return false;
                        }
                        --j;
                    }
                    int ipv4End = ip.indexOf(37, ipv4Start + 7);
                    if (ipv4End < 0) {
                        ipv4End = end;
                    }
                    return Util.isValidIpV4Address(ip, ipv4Start, ipv4End);
                }
                case '%': {
                    end = i;
                    break block5;
                }
                default: {
                    return false;
                }
            }
        }
        if (compressBegin < 0) {
            return colons == 7 && wordLen > 0;
        }
        return compressBegin + 2 == end || wordLen > 0 && (colons < 8 || compressBegin <= start);
    }

    private static boolean isValidNumericChar(char c) {
        return c >= '0' && c <= '9';
    }

    private static boolean isValidIPv4MappedChar(char c) {
        return c == 'f' || c == 'F';
    }

    private static boolean isValidHexChar(char c) {
        return c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f';
    }

    public static void deleteFileTree(File directory) throws IOException {
        if (directory.exists()) {
            Files.walkFileTree(directory.toPath(), DeletingFileVisitor.INSTANCE);
        }
    }

    private Util() {
    }
}

