/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.internal.api.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.linecorp.centraldogma.internal.shaded.guava.base.Ascii;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.internal.shaded.guava.base.Preconditions;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Objects;

public class AccessToken {
    private static final String BEARER = "Bearer";
    private final String accessToken;
    private final long expiresIn;
    private final String refreshToken;
    private final Instant deadline;

    public AccessToken(String accessToken, long expiresIn) {
        this(BEARER, accessToken, expiresIn, "");
    }

    @JsonCreator
    public AccessToken(@JsonProperty(value="token_type") String tokenType, @JsonProperty(value="access_token") String accessToken, @JsonProperty(value="expires_in") long expiresIn, @JsonProperty(value="refresh_token") String refreshToken) {
        Objects.requireNonNull(tokenType, "tokenType");
        Preconditions.checkArgument(Ascii.equalsIgnoreCase(tokenType, BEARER), "tokenType: %s (expected: %s)", (Object)tokenType, BEARER);
        this.accessToken = Objects.requireNonNull(accessToken, "accessToken");
        this.expiresIn = expiresIn;
        this.refreshToken = Objects.requireNonNull(refreshToken, "refreshToken");
        this.deadline = Instant.now().plus(expiresIn, ChronoUnit.SECONDS);
    }

    @JsonProperty(value="access_token")
    public String accessToken() {
        return this.accessToken;
    }

    @JsonProperty(value="expires_in")
    public long expiresIn() {
        return this.expiresIn;
    }

    @JsonProperty(value="token_type")
    public String tokenType() {
        return BEARER;
    }

    @JsonProperty(value="refresh_token")
    public String refreshToken() {
        return this.refreshToken;
    }

    public Instant deadline() {
        return this.deadline;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("accessToken", this.accessToken).add("expiresIn", this.expiresIn).add("tokenType", BEARER).add("deadline", this.deadline).toString();
    }
}

