/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.internal.api.v1;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.internal.api.v1.CommitMessageDto;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class CommitDto {
    private final Revision revision;
    private final Author author;
    private final CommitMessageDto commitMessage;
    private final String pushedAt;

    public CommitDto(Revision revision, Author author, CommitMessageDto commitMessage, long commitTimeMillis) {
        this.revision = Objects.requireNonNull(revision, "revision");
        this.author = Objects.requireNonNull(author, "author");
        this.commitMessage = Objects.requireNonNull(commitMessage, "commitMessage");
        this.pushedAt = DateTimeFormatter.ISO_INSTANT.format(Instant.ofEpochMilli(commitTimeMillis));
    }

    @JsonProperty(value="revision")
    public Revision revision() {
        return this.revision;
    }

    @JsonProperty(value="author")
    public Author author() {
        return this.author;
    }

    @JsonProperty(value="commitMessage")
    public CommitMessageDto commitMessage() {
        return this.commitMessage;
    }

    @JsonProperty(value="pushedAt")
    public String pushedAt() {
        return this.pushedAt;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("revision", this.revision()).add("author", this.author()).add("commitMessage", this.commitMessage()).add("pushedAt", this.pushedAt()).toString();
    }
}

