/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.internal.api.v1;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.linecorp.centraldogma.common.Markup;
import com.linecorp.centraldogma.internal.api.v1.CommitMessageDtoDeserializer;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.internal.shaded.guava.base.Strings;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonDeserialize(using=CommitMessageDtoDeserializer.class)
public class CommitMessageDto {
    private final String summary;
    private final String detail;
    private final Markup markup;

    public CommitMessageDto(String summary, @Nullable String detail, @Nullable Markup markup) {
        this.summary = Objects.requireNonNull(summary, "summary");
        this.detail = Strings.isNullOrEmpty(detail) ? "" : detail;
        this.markup = markup == null ? Markup.UNKNOWN : markup;
    }

    @JsonProperty(value="summary")
    public String summary() {
        return this.summary;
    }

    @JsonProperty(value="detail")
    public String detail() {
        return this.detail;
    }

    @JsonProperty(value="markup")
    public Markup markup() {
        return this.markup;
    }

    public String toString() {
        MoreObjects.ToStringHelper stringHelper = MoreObjects.toStringHelper(this).add("summary", this.summary());
        if (!Strings.isNullOrEmpty(this.detail)) {
            stringHelper.add("detail", this.detail());
            stringHelper.add("markup", (Object)this.markup());
        }
        return stringHelper.toString();
    }
}

