/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.internal.api.v1;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.linecorp.centraldogma.common.Markup;
import com.linecorp.centraldogma.internal.api.v1.CommitMessageDto;
import java.io.IOException;

public class CommitMessageDtoDeserializer
extends StdDeserializer<CommitMessageDto> {
    private static final long serialVersionUID = 6588840723287439409L;

    protected CommitMessageDtoDeserializer() {
        super(CommitMessageDto.class);
    }

    public CommitMessageDto deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonNode jsonNode = (JsonNode)p.readValueAsTree();
        JsonNode summary = jsonNode.get("summary");
        if (summary == null || summary.textValue() == null) {
            ctxt.reportInputMismatch(CommitMessageDto.class, "commit message should have a summary.", new Object[0]);
            throw new Error();
        }
        String detail = jsonNode.get("detail") == null ? "" : jsonNode.get("detail").textValue();
        JsonNode markupNode = jsonNode.get("markup");
        Markup markup = Markup.parse(markupNode == null ? "unknown" : markupNode.textValue());
        return new CommitMessageDto(summary.textValue(), detail, markup);
    }
}

