/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.internal.api.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.linecorp.centraldogma.internal.Util;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableSet;
import java.util.Set;
import javax.annotation.Nullable;

public class CreateProjectRequest {
    private final String name;
    private final Set<String> owners;
    private final Set<String> members;

    @JsonCreator
    public CreateProjectRequest(@JsonProperty(value="name") String name, @JsonProperty(value="owners") @Nullable Set<String> owners, @JsonProperty(value="members") @Nullable Set<String> members) {
        this.name = Util.validateProjectName(name, "name");
        this.owners = owners != null ? ImmutableSet.copyOf(owners) : ImmutableSet.of();
        this.members = members != null ? ImmutableSet.copyOf(members) : ImmutableSet.of();
    }

    @JsonProperty
    public String name() {
        return this.name;
    }

    @JsonProperty
    public Set<String> owners() {
        return this.owners;
    }

    @JsonProperty
    public Set<String> members() {
        return this.members;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("name", this.name()).add("owners", this.owners()).add("members", this.members()).toString();
    }
}

