/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.internal.api.v1;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.linecorp.centraldogma.common.EntryType;
import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class EntryDto<T> {
    private final Revision revision;
    private final String path;
    private final EntryType type;
    private final T content;
    private final String url;

    public EntryDto(Revision revision, String path, EntryType type, String projectName, String repoName, @Nullable T content) {
        this.revision = Objects.requireNonNull(revision, "revision");
        this.path = Objects.requireNonNull(path, "path");
        this.type = Objects.requireNonNull(type, "type");
        this.content = content;
        this.url = "/api/v1/projects/" + projectName + "/repos" + '/' + repoName + "/contents" + path;
    }

    @JsonProperty
    public Revision revision() {
        return this.revision;
    }

    @JsonProperty
    public String path() {
        return this.path;
    }

    @JsonProperty
    public EntryType type() {
        return this.type;
    }

    @JsonProperty
    @Nullable
    public T content() {
        return this.content;
    }

    @JsonProperty
    @Nullable
    public String url() {
        return this.url;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).omitNullValues().add("revision", this.revision).add("path", this.path).add("type", (Object)this.type).add("content", this.content).toString();
    }
}

